;
; This routine displays a 24 bit binary in C_FREQH, C_FREQM and C_FREQL on the
; LCD in the left most position in the following format ####.#
DISP_C_FREQ:
				movlw	LCD_HOME			; Position cursor leftmost on first line
				call	LCDPUTCMD
				movf	C_FREQH,W
				movwf	nratorH
				movf	C_FREQM,W
				movwf	nratorM
				movf	C_FREQL,W
				movwf	nratorL

				clrf	denomH
				movlw	0x27				;Load up 1 MHz 
				movwf	denomM		
				movlw	0x10
				movwf	denomL
				call	DIVIDE				;f/1 MHz
				clrf	denomH
				movlw	0x03				;Load up 100 kHz
				movwf	denomM		
				movlw	0xe8
				movwf	denomL
				call	DIVIDE				;f/100 kHz
				clrf	denomH
				clrf	denomM				;Load up 10 kHz
				movlw	0x64
				movwf	denomL
				call	DIVIDE				;f/10 kHz
				clrf	denomH
				clrf	denomM				;Load up 1 kHz
				movlw	0x0a
				movwf	denomL
				call	DIVIDE				;f/1 kHz
				movlw	'.'
				CALL	LCDPUTCHAR			; Display .
				movf	remainL,W			; remanider = 100Hz
				addlw	0x30				; convert to ASCII
				call 	LCDPUTCHAR			;Display
				return
;
; This routine includes the 24X15 Divide code
DIVIDE:
Divide_24x24:
				movlw	.24					; set decimal 24 loop count
				movwf	BCount
				movf	nratorH,W 			; copy Numerator into Shift Holding ram registers
				movwf	shiftH
				movf 	nratorM,W
				movwf	shiftM
				movf	nratorL,W
				movwf	shiftL
				clrf	nratorH				; clear final Answer Numerator Ram locations
				clrf	nratorM
				clrf	nratorL

				clrf	remainH  			;  clear final Answer Remainder Ram locations
				clrf	remainM
				clrf	remainL
dloop:
				bcf		STATUS,C  			; bit clear Carry Flag in STATUS register
				rlf		shiftL,F  			; Shift numerator(dividend) Left to move
				rlf		shiftM,F  			; next bit to remainder
				rlf		shiftH,F  			; and shift in next bit of result

				rlf		remainL,F 			; shift carry (next Dividend bit) into remainder
				rlf		remainM,F
				rlf		remainH,F
				movf	denomH,W
				subwf	remainH,W  			; subtract divsor(denomH) from(newly shifted left) Remainder HIGH byte.
				btfss	STATUS,Z
				goto	nochk		  		; skip if result was ZERO from good subtraction result

				movf	denomM,W
				subwf	remainM,W  			; subtract divsor(denomM) from(newly shifted left) Remainder MIDDLE byte.
				btfss	STATUS,Z
				goto	nochk		 		; skip if result was ZERO from good subtraction result

				movf	denomL,W
				subwf	remainL,W  			; subtract divsor(denomL) from(newly shifted left) Remainder LOW byte.
nochk:
				btfss	STATUS,C   			;  Carry SET? then denom is larger than reemainder
				goto	nogo

				movf	denomL,W			 
				subwf	remainL,F   	 	; Subtract denominator from remainder value in Low Byte
				btfsc	STATUS,C       		; Carry Set? Then execute fixup code for when a borrow is generated
				goto	nodec_remainM   	; when no borrow bit is needed from the higher byte positions.
				decf	remainM,F     		; Decrement to Borrow from Middle Byte, because carry was SET.
				movf	remainM,W
				xorlw	0xff				; Check if rollover from Borrow occurred. remainM value went from 0 to 0xFF 
				btfsc	STATUS,Z
				decf	remainH,F			; ZERO bit set, yes rollover, so Decrement to Borrow from High Byte, too!
nodec_remainM:
				movf	denomM,W
				subwf	remainM,F			; Subtract denominator from remainder value in Middle Byte
				btfss	STATUS,C
				decf	remainH,F			; Decrement High Byte, to borrow 1 bit
				movf	denomH,W   		 
				subwf	remainH,F			; Subtract denominator from remainder value in High Byte
				bsf		STATUS,C			; set CARRY bit to rotate in Numerator Result next.
nogo:
				rlf		nratorL,F			; rotate Numerator result left 1 bit
				rlf		nratorM,F
				rlf		nratorH,F
				decfsz	BCount,F			; decrement the Loop Bit Counter
				goto	dloop

				movlw	0x30
				addwf	nratorL,W			;convert to ASCII
				call	LCDPUTCHAR			;Send the answer
				movf	remainH,W			;Last remainder = next numerator
				movwf	nratorH
				movf	remainM,W
				movwf	nratorM
				movf	remainL,W
				movwf	nratorL
				return
FREQ