 ;
; This routine containes the radio setup routines
SETUP:
				bsf		SSTAT,RATE			; Display wheel setting
				movlw	0x10
				movwf	SET_FNC
S_LOOP:
				btfss	CNT_STAT,NOT_CTNG
				goto	S_CNTING			; If not counting start a count

				clrf	TMR1L				; Clear Timer1
				clrf	TMR1H				

				movf	SET_FNC,W
				andlw	0x0c
				btfss	_Z
				goto	S_LO_ON
				bcf		PORTC,3				; Apply BFO to Counter				
				goto	S_CNT_FLG
S_LO_ON:
				bcf		PORTC,4				; Apply LO to Counter				
S_CNT_FLG:
				movlw	0x02
				movwf	CNT_STAT			; Clear not ocunting flag, set LO counting flag
				movlw	.20
				movwf	BCount
				decfsz	BCount,F
				goto	$-1
				movlw	0x3d				; Timer0 Value
				movwf	TMR0

				bcf		INTCON,T0IF			; Clear and old interrupt flags
				bsf		INTCON,T0IE			; Enable the T0 interrupt
				goto	S_CNTR_DONE

S_CNTING:				
				btfss	CNT_STAT,DONE_CTNG	; Check if count is complete
				goto	S_CNTR_DONE
				movlw	0x01
				movwf	CNT_STAT			; Count Done
				movlw	0x02
				subwf	TMR1L,W				; Get and save BFO count
				movwf	C_FREQL
				movf	TMR1H,W				; Get and save BFO count
				btfss	_C
				decf	TMR1H,W
				movwf	C_FREQM
				clrf	C_FREQH				
				movlw	0x20
				xorwf	SSTAT,F
				btfss	SSTAT,S_CNT
				call	DISP_C_FREQ
S_CNTR_DONE:
;
; High resolution BFO tracking system
				movlw	0x10
				andwf	SET_FNC,W
				btfsc	_Z
				call	BFO_HIRES
;
; Update Frequency?
				btfss	SSTAT,UPDATE_FR
				goto	S_FP
				bcf		SSTAT,UPDATE_FR
				call	LO_FREQ
;
; Front Panel Switch Processor
S_FP:
				movf	FP_Switch,W			; Save last state
				movwf	PREV_FP
				call	FP_READ				; read current state
				movf	FP_Switch,W			; Get current state
				xorwf	PREV_FP,W			; Look For Changes
				movwf	FP_TEMP				; Save Result

				movlw	.250
				call	X_DELAY100			; Wait 25 msec for switch bounce				
				btfss	FP_TEMP,SWAP		; Select Switch
				goto	S_NOT_SWAP	
				btfss	FP_Switch,SWAP		; Process on button up
				goto	S_END_FP
				bcf		_C					; Clear carry bit
				rlf		SET_FNC,F			; Change Mode
				btfss	SET_FNC,5			; roll around 
				goto	S_SWAP1
				movlw	0x01
				movwf	SET_FNC
S_SWAP1:
				call	S_DISPLAY
				goto	S_END_FP
S_NOT_SWAP:
				btfss	FP_TEMP,SELECT		; Select Switch
				goto	S_NOT_SELECT	
				btfss	FP_Switch,SELECT		; Process on button up
				goto	S_END_FP
				btfss	SET_FNC,0
				goto	S_CHK_USB
				movlw	BFO_LSB
				goto	S_BFO_STORE	
S_CHK_USB:
				btfss	SET_FNC,1
				goto	S_NOT_SELECT
				movlw	BFO_USB
S_BFO_STORE:
				movwf	EE_ADDR
				movf	WHEEL,W
				movwf	EE_DATA
				call	EE_WRITE
				call	S_DISPLAY
S_NOT_SELECT:

S_END_FP:
;
; Wheel Position Display
				btfss	SSTAT,WHL
				goto	S_END_WHL			; Wheel hasn't changed
				bcf		SSTAT,WHL			; Clear status flag
				movlw	0x14
				call	LCDSDDA				; Move to 17th digit
				btfss	SET_FNC,4			; BFO RANGE?
				goto	LSB_USB_BFO
				movlw	0x33				;limit range to 1-5 volts
				subwf	WHEEL,W
				btfsc	_C
				goto	S_BFO_D
				movlw	0x33
				movwf	WHEEL
S_BFO_D:
				movf	WHEEL,W
				movwf	CCPR1L
				goto	S_END_WHL

LSB_USB_BFO:
				movlw	0x9d
				subwf	WHEEL,W
				movwf	nratorL
				movlw	0x00
				btfss	_C
				movlw	0x01				
				addlw	0x09
				subwf	BFO_FRH,W
				movwf	nratorM
				movlw	0x06
				movwf	nratorH

				movlw	0x01
				movwf	denomH
				movlw	0x86				;Load up 1 MHz 
				movwf	denomM		
				movlw	0xa0
				movwf	denomL
				call	DIVIDE				;f/1 MHz

				clrf	denomH
				movlw	0x27				;Load up 0.1 MHz 
				movwf	denomM		
				movlw	0x10
				movwf	denomL
				call	DIVIDE				;f/0.11 MHz
				clrf	denomH
				movlw	0x03				;Load up 10 kHz
				movwf	denomM		
				movlw	0xe8
				movwf	denomL
				call	DIVIDE				;f/10 kHz
				clrf	denomH
				clrf	denomM				;Load up 1 kHz
				movlw	0x64
				movwf	denomL
				call	DIVIDE				;f/1 kHz
				movlw	'.'
				CALL	LCDPUTCHAR			; Display .
				clrf	denomH
				clrf	denomM				;Load up .1 kHz
				movlw	0x0a
				movwf	denomL
				call	DIVIDE				;f/1 kHz
				movf	remainL,W			; remanider = 10Hz
				addlw	0x30				; convert to ASCII
				call 	LCDPUTCHAR			;Display



S_END_WHL:
				goto	S_LOOP

;
; Displays a ASCII character from a HEX nibble in W
DISP_HEX:
				movwf	ACount
				movlw	0x0a
				subwf	ACount,W
				btfsc	_C
				addlw	0x07
				addlw	0x3a
				call 	LCDPUTCHAR
				return
S_DISPLAY:
				movlw	LCD_CLEAR
				call	LCDPUTCMD
				movlw	.250
				call	X_DELAY100			; Wait 25 msec for switch bounce				
				bcf		INTCON,T0IE			; Dump Current Count
				movlw	0x01
				movwf	CNT_STAT			; Count Done
				movlw	0x08
				call	LCDSDDA
				btfss	SET_FNC,0
				goto	S_D_1
				movlw	'B'
				call 	LCDPUTCHAR
				movlw	'F'
				call 	LCDPUTCHAR
				movlw	'O'
				call 	LCDPUTCHAR
				movlw	' '
				call 	LCDPUTCHAR
				movlw	'L'
				call 	LCDPUTCHAR
				movlw	'S'
				call 	LCDPUTCHAR
				movlw	'B'
				call 	LCDPUTCHAR
				movlw	0x04
				movwf	OPMODE
				call	SET_OP_MODE
				return
S_D_1
				btfss	SET_FNC,1
				goto	S_D_2
				movlw	'B'
				call 	LCDPUTCHAR
				movlw	'F'
				call 	LCDPUTCHAR
				movlw	'O'
				call 	LCDPUTCHAR
				movlw	' '
				call 	LCDPUTCHAR
				movlw	'U'
				call 	LCDPUTCHAR
				movlw	'S'
				call 	LCDPUTCHAR
				movlw	'B'
				call 	LCDPUTCHAR
				movlw	0x02
				movwf	OPMODE
				call	SET_OP_MODE
				return
S_D_2
				btfss	SET_FNC,2
				goto	S_D_3
				bsf		PORTC,1
				movlw	'L'
				call 	LCDPUTCHAR
				movlw	'O'
				call 	LCDPUTCHAR
				movlw	' '
				call 	LCDPUTCHAR
				movlw	'A'
				call 	LCDPUTCHAR
				goto	S_11_SPACE
S_D_3:
				btfss	SET_FNC,3
				goto	S_D_4
 				bcf		PORTC,1
				movlw	'L'
				call 	LCDPUTCHAR
				movlw	'O'
				call 	LCDPUTCHAR
				movlw	' '
				call 	LCDPUTCHAR
				movlw	'B'
				call 	LCDPUTCHAR
				goto	S_11_SPACE
S_D_4
				movlw	'B'
				call 	LCDPUTCHAR
				movlw	'F'
				call 	LCDPUTCHAR
				movlw	'O'
				call 	LCDPUTCHAR
				movlw	' '
				call 	LCDPUTCHAR
				movlw	0x02
				movwf	OPMODE
				call	SET_OP_MODE
				goto	S_11_SPACE
S_11_SPACE:
				movlw	.11
				movwf	BCount
S_11_LOOP:
				movlw	' '
				call 	LCDPUTCHAR
				decfsz	BCount,F
				goto	S_11_LOOP
				return