;
;
; TX Wattmeter Processor
TX_METER:
				movf	TXM_STAT,F			;Check for status=0
				btfss	_Z
				goto	TXM_DISP
				incf	TXM_STAT,F			;Status = 1
				movlw	0xA1
				movwf	ADCON0				; Apply TX Power to A/D converter
				movlw	0x14
				call	LCDSDDA				; Position LCD 
				movlw	0xA5				; Start Conversion
				movwf	ADCON0
				clrf	TXM_DATA			; Data = 0
TXM_A2D_LP:
				btfsc	ADCON0,GO_DONE
				goto	TXM_A2D_LP			; Wait until Conversion is complete
				movf	ADRESH,W
				movwf	TXM_DATA			; Store Result
				return
TXM_DISP:
				btfss	TXM_STAT,0
				goto	TXM_D1
				bcf		_C					; Clear carry
				rlf		TXM_STAT,F			; Point to next character
				movlw	0x10
				subwf	TXM_DATA,W			; Compare to Data
				btfss	_C
				goto	TXM_OFF
				goto	TXM_ON								

TXM_D1
				btfss	TXM_STAT,1
				goto	TXM_D2
				bcf		_C					; Clear carry
				rlf		TXM_STAT,F			; Point to next character
				movlw	0x30
				subwf	TXM_DATA,W			; Compare to Data
				btfss	_C
				goto	TXM_OFF
				goto	TXM_ON								

TXM_D2
				btfss	TXM_STAT,2
				goto	TXM_D3
				bcf		_C					; Clear carry
				rlf		TXM_STAT,F			; Point to next character
				movlw	0x50
				subwf	TXM_DATA,W			; Compare to Data
				btfss	_C
				goto	TXM_OFF
				goto	TXM_ON								

TXM_D3
				btfss	TXM_STAT,3
				goto	TXM_D4
				bcf		_C					; Clear carry
				rlf		TXM_STAT,F			; Point to next character
				movlw	0x70
				subwf	TXM_DATA,W			; Compare to Data
				btfss	_C
				goto	TXM_OFF
				goto	TXM_ON								

TXM_D4
				btfss	TXM_STAT,4
				goto	TXM_D5
				bcf		_C					; Clear carry
				rlf		TXM_STAT,F			; Point to next character
				movlw	0x90
				subwf	TXM_DATA,W			; Compare to Data
				btfss	_C
				goto	TXM_OFF
				goto	TXM_ON								

TXM_D5
				btfss	TXM_STAT,5
				goto	TXM_D6
				bcf		_C					; Clear carry
				rlf		TXM_STAT,F			; Point to next character
				movlw	0xb0
				subwf	TXM_DATA,W			; Compare to Data
				btfss	_C
				goto	TXM_OFF
				goto	TXM_ON								

TXM_D6
				btfss	TXM_STAT,6
				goto	TXM_D7
				bcf		_C					; Clear carry
				rlf		TXM_STAT,F			; Point to next character
				movlw	0xd0
				subwf	TXM_DATA,W			; Compare to Data
				btfss	_C
				goto	TXM_OFF
				goto	TXM_ON								
TXM_D7
				clrf	TXM_STAT			; Point to next character
				movlw	0xf0
				subwf	TXM_DATA,W			; Compare to Data
				btfss	_C
				goto	TXM_OFF
				goto	TXM_ON								

TXM_OFF			movlw	0x4f
				call	LCDPUTCHAR
				return
TXM_ON			movlw	0x00
				call	LCDPUTCHAR
				return
