'						October 12, 1998
'						file:rotor.bas
'
'Parallax, Inc Basic Stamp1 Single Board Computer (SBC)
'
'Ham M with analog meter readout version
'
'Input/Output Arrangement:
'
'	I/O NR.		FUNCTION
'	  0		CW input command
'	  1		CCW input command (1&2 = auto command)
'	  2		Input data from ADCs 
'	  3		ADC chip select (CS) ADC0 or ADC1
'	  4		clock signals to ADCs
'	  5		rotor brake release and indicator lamps
'	  6		CW rotor output
'	  7		CCW rotor output
'
'Description: 
'
'Stamp1 SBC receives direction commands -either CW, CCW or AUTO
'from rotor control unit.  CW and CCW inputs provided by existing
'lever switches on front panel of control unit (left lever, CCW; right
'lever, CW; center lever, AUTO).
'
'AUTO command (DIAL) potentiometer input uses ADC0 analog to digital
'converter to provide new position data to SBC. Rotor potentiometer uses 
'ADC1 analog to digital converter to provide a digital value of current
'rotor position.
'
'Software compares two values and determines which direction rotor is
'to turn for desired new rotor position.  Existing analog meter located
'on rotor control unit indicates current rotor position.
'
'Rotor brake is released sequentially i.e., just before applying AC
'power to rotor motor and re-engaging slightly after rotor power is
'removed and rotor is in new selected position.
'
'To reduce the possibility of rotor sticking due to friction, ice or snow
'build up in automatic mode, the rotor, via a software routine, is rocked
'back and forth twice before attempting to assume new position.  
'
'If the rotor should remain stalled in spite of the above, a software clock
'will time out after approximately 60 seconds and shut power down.  At
'this point the operator can attempt to unstick the rotor with manual
'controls or repeat with automatic operation.
'
'Clockwise (CW) and counter-clockwise (CCW) functions operate either 
'manually using lever switches noted above or under automatic control
'(AUTO).

'Program Begins Here!

symbol brakedelay = 500		'brake delay (milliseconds)
symbol limitvalue = 240		'approximately one minute before shutdown
symbol rotordata  = b0		'present position data
symbol scaninput  = b1		'direction command data (cw, ccw or auto)
symbol dialdata   = b3		'selected new position data
symbol timedelay  = b4		'time delay counter 

bsave				'save object file (code.obj)
				'file renamed:  ROTOR.OBJ
dirs = %11111000		'Set inputs and outputs, in=0, out =1

MANUAL:				'set up manual mode
timedelay = 0			'reset timeout counter to zero
gosub rotorpot			'get current rotor position
gosub dialpot			'get initial dial potentiometer setting

scaninput=pins			'read in all input ports
scaninput=scaninput & %00000011	'screen out all but ports 0 and 1
if scaninput=%00000001 then runcw'if port 0 = 1 then rotor moves cw
if scaninput=%00000010 then runccw'if port 1 = 1 then rotor moves ccw
if scaninput=%00000011 then runauto'if port 1 and 2 = 1 then go auto mode 
low 6 				'turn off rotor cw
low 7				'turn off rotor ccw
pause brakedelay		'wait a bit before braking
low 5				'engage rotor brake
goto MANUAL			'look for any input

runcw:				'manual clockwise mode
high 5				'disengage rotor brake			
pause brakedelay		'time for brake to disengage
high 6				'operate rotor cw
goto MANUAL			'look for any input

runccw:				'manual counter-clockwise mode
high 5				'disengage rotor brake 
pause brakedelay		'time for brake to disengage
high 7				'operate rotor ccw
goto MANUAL			'look for any input

runauto:			'automatic mode
high 5				'disengage rotor brake
pause brakedelay 		'time for brake to disengage
if dialdata = rotordata then endrotor'if new position=preset then end 
if dialdata > rotordata then autocw'rotate CW to new position
if dialdata < rotordata then autoccw'rotate CCW to new position
goto MANUAL			'If all else fails!

autocw:				'rotor clockwise routine
high 7				'loosen mast bearing drag, go ccw
pause brakedelay		'for a jiffy
low 7				'stop rotor
pause brakedelay		'for a jiffy
high 6				'start it up again, go cw
pause brakedelay		'for a jiffy
low 6				'stop rotor
pause brakedelay		'for a jiffy
high 7				'start it up again, go ccw
pause brakedelay		'for a jiffy
low 7				'end drag routine
gocw:
high 6				'apply rotor power 
gosub rotorpot			'read present rotor position
if rotordata = dialdata then endrotor'end when new position = desired
timedelay = timedelay +1	'add one to timeout counter
if timedelay = limitvalue then endrotor'if timeout, disable rotor power
goto gocw			'keep going until there

autoccw:			'rotor counter-clockwise routine
high 6				'loosen mast bearing drag, go cw
pause brakedelay		'for a jiffy
low 6				'stop rotor
pause brakedelay		'for a jiffy
high 7				'start it up again, go ccw
pause brakedelay		'for a jiffy
low 7				'stop rotor
pause brakedelay		'for a jiffy
high 6				'start it up again, to cw
pause brakedelay		'for a jiffy
low 6				'end drag routine
goccw:
high 7				'apply rotor power 
gosub rotorpot			'read present rotor position
if rotordata = dialdata then endrotor'end when new position = desired
timedelay = timedelay +1	'add one to timeout counter
if timedelay = limitvalue then endrotor'if timeout, disable rotor power
goto goccw			'keep going until there

endrotor:			'end rotor motion
low 6				'turn off CW rotor power
low 7				'turn off CCW rotor power
pause brakedelay		'wait for motion to cease
low 5				're-engage brake
goto MANUAL			'return to manual control

'rotor potentiometer analog to digital converter routine
rotorpot:

low 4				'Put clock in starting state	
high 3				'select adc chip
pulsout 4, 1			'send out clock pulse
b0  = 0				'clear data
for b2 = 1 to 8			'read 8 data bits
b0 = b0 * 2			'shift data left
pulsout 4, 1			'clock pulse
b0 = b0 + pin2			'place bit in LSB
next				'do it again (8 times)
b0 = b0 * 2 / 5			'resolution 1 part in 72 (180 X 2/5)
low 3				'deselect adc chip
debug b0			'no-op bsave to enable
'debug b3			'kill (') to enable + above
return				'return to calling point

'dial potentiometer analog to digital converter routine
dialpot:

low 4				'Put clock in starting state	
low 3				'select adc chip
pulsout 4, 1			'send out clock pulse
b3  = 0				'clear data
for b2 = 1 to 8			'read 8 data bits
b3 = b3 * 2			'shift data left
pulsout 4, 1			'clock pulse
b3 = b3 + pin2			'place bit in LSB
next				'do it again (8 times)
b3 = b3 * 2 / 5			'resolution 1 part in 72 (180 X 2/5)
high 3				'deselect adc chip
debug b3			'no-op bsave to enable
return				'return to calling point

end

'Note: to enable debug instructions, disable bsave instruction and reload
'program.  Be sure to enable bsave instruction when finished and reload
'program  
