VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.2#0"; "COMCTL32.OCX"
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Object = "{B16553C3-06DB-101B-85B2-0000C009BE81}#1.0#0"; "SPIN32.OCX"
Object = "{625E24A3-B09D-101D-85F5-6EBA1EE93AF4}#3.3#0"; "INICON32.OCX"
Begin VB.Form frmMain 
   AutoRedraw      =   -1  'True
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Hagtronics - 2 Meter Synthesized Receiver"
   ClientHeight    =   3570
   ClientLeft      =   150
   ClientTop       =   435
   ClientWidth     =   6735
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   3570
   ScaleWidth      =   6735
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame fraAudio 
      Caption         =   "Audio"
      Height          =   735
      Left            =   4080
      TabIndex        =   13
      Top             =   2400
      Width           =   2535
      Begin VB.OptionButton optAudio 
         Caption         =   "Squelch"
         Height          =   375
         Index           =   2
         Left            =   1560
         Style           =   1  'Graphical
         TabIndex        =   10
         ToolTipText     =   "Set audio squelch mode"
         Top             =   240
         Value           =   -1  'True
         Width           =   855
      End
      Begin VB.OptionButton optAudio 
         Caption         =   "Off"
         Height          =   375
         Index           =   1
         Left            =   840
         Style           =   1  'Graphical
         TabIndex        =   9
         ToolTipText     =   "Set audio off"
         Top             =   240
         Width           =   615
      End
      Begin VB.OptionButton optAudio 
         Caption         =   "On"
         Height          =   375
         Index           =   0
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   8
         ToolTipText     =   "Set audio on"
         Top             =   240
         Width           =   615
      End
   End
   Begin ComctlLib.ProgressBar pbSignal 
      Height          =   255
      Left            =   4320
      TabIndex        =   12
      ToolTipText     =   "Signal level"
      Top             =   840
      Width           =   2055
      _ExtentX        =   3625
      _ExtentY        =   450
      _Version        =   327682
      Appearance      =   0
   End
   Begin VB.Frame fraSignal 
      Caption         =   "Signal / Squelch"
      Height          =   2295
      Left            =   4080
      TabIndex        =   11
      Top             =   120
      Width           =   2535
      Begin ComctlLib.Slider sldSquelch 
         Height          =   630
         Left            =   120
         TabIndex        =   7
         ToolTipText     =   "Set squelch level"
         Top             =   1200
         Width           =   2295
         _ExtentX        =   4048
         _ExtentY        =   1111
         _Version        =   327682
         LargeChange     =   10
         Max             =   100
         TickStyle       =   2
         TickFrequency   =   5
      End
      Begin VB.Label Label6 
         AutoSize        =   -1  'True
         Caption         =   "Squelch Level Set"
         Height          =   195
         Left            =   600
         TabIndex        =   15
         Top             =   1800
         Width           =   1305
      End
      Begin VB.Label Label5 
         AutoSize        =   -1  'True
         Caption         =   "Received Signal Level"
         Height          =   195
         Left            =   480
         TabIndex        =   14
         Top             =   480
         Width           =   1605
      End
   End
   Begin ComctlLib.StatusBar sbStatusBar 
      Align           =   2  'Align Bottom
      Height          =   270
      Left            =   0
      TabIndex        =   0
      ToolTipText     =   "Status display"
      Top             =   3300
      Width           =   6735
      _ExtentX        =   11880
      _ExtentY        =   476
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   3
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   6694
            Text            =   "Status"
            TextSave        =   "Status"
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel2 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   6
            AutoSize        =   2
            TextSave        =   "10/11/98"
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel3 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   5
            AutoSize        =   2
            TextSave        =   "7:23 AM"
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.Timer tmrMain 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   4800
      Top             =   3120
   End
   Begin MSCommLib.MSComm Comm_Control 
      Left            =   5280
      Top             =   3120
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   327681
      DTREnable       =   -1  'True
   End
   Begin IniconLib.Init IniControl 
      Left            =   5880
      Top             =   3120
      _Version        =   196611
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      Application     =   ""
      Parameter       =   ""
      Value           =   ""
      Filename        =   ""
   End
   Begin VB.Frame fraMemory 
      Caption         =   "Memory Tuning"
      Height          =   3015
      Left            =   120
      TabIndex        =   16
      Top             =   120
      Width           =   3855
      Begin VB.CommandButton cmdMemScanStop 
         Caption         =   "Memory Scan Stop"
         Height          =   375
         Left            =   2040
         MaskColor       =   &H80000012&
         TabIndex        =   40
         ToolTipText     =   "Stop Scan"
         Top             =   2520
         Width           =   1575
      End
      Begin VB.CommandButton cmdMemScanStart 
         Caption         =   "Memory Scan Start"
         Height          =   375
         Left            =   240
         MaskColor       =   &H80000012&
         TabIndex        =   39
         ToolTipText     =   "Start Scan"
         Top             =   2520
         Width           =   1575
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   9
         Left            =   1920
         TabIndex        =   26
         ToolTipText     =   "Click to set"
         Top             =   1800
         Width           =   1815
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   8
         Left            =   1920
         TabIndex        =   25
         ToolTipText     =   "Click to set"
         Top             =   1440
         Width           =   1815
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   7
         Left            =   1920
         TabIndex        =   24
         ToolTipText     =   "Click to set"
         Top             =   1080
         Width           =   1815
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   6
         Left            =   1920
         TabIndex        =   23
         ToolTipText     =   "Click to set"
         Top             =   720
         Width           =   1815
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   5
         Left            =   1920
         TabIndex        =   22
         ToolTipText     =   "Click to set"
         Top             =   360
         Width           =   1815
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   4
         Left            =   120
         TabIndex        =   21
         ToolTipText     =   "Click to set"
         Top             =   1800
         Width           =   1815
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   3
         Left            =   120
         TabIndex        =   20
         ToolTipText     =   "Click to set"
         Top             =   1440
         Width           =   1815
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   2
         Left            =   120
         TabIndex        =   19
         ToolTipText     =   "Click to set"
         Top             =   1080
         Width           =   1815
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   1
         Left            =   120
         TabIndex        =   18
         ToolTipText     =   "Click to set"
         Top             =   720
         Width           =   1815
      End
      Begin VB.OptionButton optMemory 
         Caption         =   "0123456789012345"
         Height          =   195
         Index           =   0
         Left            =   120
         TabIndex        =   17
         ToolTipText     =   "Click to set"
         Top             =   360
         Width           =   1815
      End
      Begin VB.Label lblMemScan 
         AutoSize        =   -1  'True
         Caption         =   "Scanning"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H000000FF&
         Height          =   300
         Left            =   1320
         TabIndex        =   42
         Top             =   2160
         Width           =   1140
      End
   End
   Begin VB.Frame fraManual 
      Caption         =   "Manual Tuning"
      Height          =   3015
      Left            =   120
      TabIndex        =   27
      Top             =   120
      Width           =   3855
      Begin VB.Frame Frame2 
         Caption         =   "Scan Control"
         Height          =   1215
         Left            =   120
         TabIndex        =   28
         Top             =   1680
         Width           =   3615
         Begin VB.CommandButton cmdScanStop 
            Caption         =   "Scan Stop"
            Height          =   375
            Left            =   120
            TabIndex        =   38
            ToolTipText     =   "Stop scan"
            Top             =   720
            Width           =   1215
         End
         Begin VB.CommandButton cmdScanStart 
            Caption         =   "Scan Start"
            Height          =   375
            Left            =   120
            TabIndex        =   37
            ToolTipText     =   "Start scan"
            Top             =   240
            Width           =   1215
         End
         Begin VB.OptionButton optStep 
            Caption         =   "5 kHz Step"
            Height          =   255
            Index           =   0
            Left            =   2160
            TabIndex        =   5
            ToolTipText     =   "Set scan step size"
            Top             =   360
            Width           =   1215
         End
         Begin VB.OptionButton optStep 
            Caption         =   "10 kHz Step"
            Height          =   255
            Index           =   1
            Left            =   2160
            TabIndex        =   6
            ToolTipText     =   "Set scan step size"
            Top             =   720
            Value           =   -1  'True
            Width           =   1215
         End
      End
      Begin Spin.SpinButton spnFrequency 
         Height          =   615
         Index           =   0
         Left            =   2040
         TabIndex        =   4
         ToolTipText     =   "Tune frequency"
         Top             =   960
         Width           =   375
         _Version        =   65536
         _ExtentX        =   661
         _ExtentY        =   1085
         _StockProps     =   73
         TdThickness     =   1
      End
      Begin Spin.SpinButton spnFrequency 
         Height          =   615
         Index           =   1
         Left            =   1680
         TabIndex        =   3
         ToolTipText     =   "Tune frequency"
         Top             =   960
         Width           =   375
         _Version        =   65536
         _ExtentX        =   661
         _ExtentY        =   1085
         _StockProps     =   73
         TdThickness     =   1
      End
      Begin Spin.SpinButton spnFrequency 
         Height          =   615
         Index           =   2
         Left            =   1320
         TabIndex        =   2
         ToolTipText     =   "Tune frequency"
         Top             =   960
         Width           =   375
         _Version        =   65536
         _ExtentX        =   661
         _ExtentY        =   1085
         _StockProps     =   73
         TdThickness     =   1
      End
      Begin Spin.SpinButton spnFrequency 
         Height          =   615
         Index           =   3
         Left            =   840
         TabIndex        =   1
         ToolTipText     =   "Tune frequency"
         Top             =   960
         Width           =   375
         _Version        =   65536
         _ExtentX        =   661
         _ExtentY        =   1085
         _StockProps     =   73
         TdThickness     =   1
      End
      Begin VB.Label lblScan 
         Alignment       =   2  'Center
         AutoSize        =   -1  'True
         Caption         =   "Scan"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H000000FF&
         Height          =   360
         Left            =   2685
         TabIndex        =   41
         Top             =   1080
         Width           =   675
      End
      Begin VB.Label lblFrequencyDisplay 
         Alignment       =   2  'Center
         Caption         =   "6"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   495
         Index           =   0
         Left            =   2040
         TabIndex        =   36
         ToolTipText     =   "Receive frequency"
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblFrequencyDisplay 
         Alignment       =   2  'Center
         Caption         =   "5"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   495
         Index           =   1
         Left            =   1680
         TabIndex        =   35
         ToolTipText     =   "Receive frequency"
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblFrequencyDisplay 
         Alignment       =   2  'Center
         Caption         =   "2"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   495
         Index           =   2
         Left            =   1320
         TabIndex        =   34
         ToolTipText     =   "Receive frequency"
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblFrequencyDisplay 
         Alignment       =   2  'Center
         Caption         =   "5"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   495
         Index           =   3
         Left            =   840
         TabIndex        =   33
         ToolTipText     =   "Receive frequency"
         Top             =   360
         Width           =   375
      End
      Begin VB.Label Label4 
         Alignment       =   2  'Center
         Caption         =   "4"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00000000&
         Height          =   495
         Left            =   480
         TabIndex        =   32
         ToolTipText     =   "Receive frequency"
         Top             =   360
         Width           =   375
      End
      Begin VB.Label Label1 
         Alignment       =   2  'Center
         Caption         =   "1"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   240
         TabIndex        =   31
         ToolTipText     =   "Receive frequency"
         Top             =   360
         Width           =   255
      End
      Begin VB.Label Label2 
         Alignment       =   2  'Center
         AutoSize        =   -1  'True
         Caption         =   "."
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   555
         Left            =   1185
         TabIndex        =   30
         Top             =   360
         Width           =   195
      End
      Begin VB.Label Label3 
         Alignment       =   2  'Center
         Caption         =   "MHz"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   24
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   2520
         TabIndex        =   29
         ToolTipText     =   "Receive frequency"
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuMode 
      Caption         =   "&Mode"
      Begin VB.Menu mnuManual 
         Caption         =   "&Manual Tune"
      End
      Begin VB.Menu mnuMemory 
         Caption         =   "Memo&ry Tune"
      End
      Begin VB.Menu mnuSpectrum 
         Caption         =   "&Spectrum Display"
      End
   End
   Begin VB.Menu mnuOptions 
      Caption         =   "&Options"
      Begin VB.Menu mnuSetOptions 
         Caption         =   "&Set Receiver Options..."
      End
      Begin VB.Menu mnuRawData 
         Caption         =   "&Raw Data Display..."
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&About"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About two_meter..."
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'=====[ The main form of the project ]================================

'Written By: Steve Hageman, June 1998

'Copyright information contained on About.Frm

'=====================================================================
'Version Control:
'1.0.0 - Initial release - 10Jun98
'=====================================================================

'The usual
Option Explicit
Option Base 0

'Private Module globals
Private MemoryCaption$(9)   'The memory channel text caption
Private MemoryFrequency#(9) 'The memory channel frequency
Private ScanMode%           'Flag for scan mode (True = Scan ON)
Private StepSize!           '0.005 or 0.010 for scanning step size
Private SquelchMode%        'True for squelch mode on
Private SquelchValue%       'Scaled squelch value (scaled same as RSSI value read)

Private OldFrequency#       'The last frequency set

'Displays the frequency properly on the manual frame of the form

Private Sub Display_Frequency()

    'Decompose the digits
    lblFrequencyDisplay(3).Caption = Mid$(Format$(TunedFrequency#, "###.000"), 3, 1) 'MHz digit
    lblFrequencyDisplay(2).Caption = Mid$(Format$(TunedFrequency#, "###.000"), 5, 1) '100 kHz digit
    lblFrequencyDisplay(1).Caption = Mid$(Format$(TunedFrequency#, "###.000"), 6, 1) '10 kHz digit
    lblFrequencyDisplay(0).Caption = Mid$(Format$(TunedFrequency#, "###.000"), 7, 1) '1 kHz digit
    
    'Force a display update
    DoEvents

End Sub

'Read the ini file in

Sub Read_Ini()
Dim ini_text$
Dim ctr%
    
    '----- Set the error handler
    On Error GoTo read_ini_err
    
    '----- Read the basic setup parameters from the ini file
    'Setup ini control
    IniControl.filename = "two_Meter.ini"
    IniControl.Application = "TWO_METER"
    
    '-- Get last frequency
    IniControl.Parameter = "LAST_FREQUENCY"
    ini_text$ = IniControl.Value
    
    'Check value
    If CDbl(ini_text$) > 148 Or CDbl(ini_text$) < 144 Then
        'Number is out of range, so default it
        TunedFrequency# = 146#
    Else
        'Number is in range, so save it
        TunedFrequency# = CDbl(ini_text$)
    End If
    
    '-- Get rssi offset
    IniControl.Parameter = "RSSI_OFFSET"
    ini_text$ = IniControl.Value
    
    'Check value
    If CInt(ini_text$) < 0 Or CInt(ini_text$) > 50 Then
        'Out of range so default it
        Rssi_Offset% = 13
    Else
        'Number was good, so use it
        Rssi_Offset% = CInt(ini_text$)
    End If
    
    '-- Get rssi offset
    IniControl.Parameter = "RSSI_GAIN"
    ini_text$ = IniControl.Value
    
    'Check value
    If CSng(ini_text$) < 2 Or CSng(ini_text$) > 6 Then
        'Out of range so default it
        Rssi_Gain! = 4.17
    Else
        'Number was good, so use it
        Rssi_Gain! = CSng(ini_text$)
    End If
    
    '-- Get Scan delay
    IniControl.Parameter = "SCAN_DELAY"
    ini_text$ = IniControl.Value
    
    'Check value
    If CInt(ini_text$) < 1 Or CInt(ini_text$) > 10 Then
        'Out of range so default it
        Scan_Delay% = 2
    Else
        'Number was good, so use it
        Scan_Delay% = CInt(ini_text$)
    End If
     
    '-- Get battery gain
    IniControl.Parameter = "BATTERY_GAIN"
    ini_text$ = IniControl.Value
    
    'Check value
    If CSng(ini_text$) < 0.5 Or CSng(ini_text$) > 1.5 Then
        'Out of range so default it
        Battery_Adjust! = 1
    Else
        'Number was good, so use it
        Battery_Adjust! = CSng(ini_text$)
    End If
    
    '-- Get squelch setting
    IniControl.Parameter = "SQUELCH"
    ini_text$ = IniControl.Value
    
    'Check value
    If CInt(ini_text$) < 0 Or CInt(ini_text$) > 100 Then
        'Out of range so default it
        sldSquelch.Value = 5
        SquelchValue% = sldSquelch.Value
    Else
        'Number was good, so use it
        sldSquelch.Value = CInt(ini_text$)
        SquelchValue% = sldSquelch.Value
    End If


    '----- Read the memory channels
    For ctr% = 0 To 9
        IniControl.Application = "MEMORY" + Format(ctr% + 1, "0")
        
        '-- Get the frequency
        IniControl.Parameter = "FREQUENCY"
        ini_text$ = IniControl.Value
        
        'Check if the frequency has been set
        If CSng(ini_text$) = 0 Then
            'Frequency has not been programmed
            MemoryFrequency#(ctr%) = Empty
        Else
            'Set the frequency in memory
            MemoryFrequency#(ctr%) = CSng(ini_text$)
        End If
        
        '-- Get the title
        IniControl.Parameter = "TITLE"
        ini_text$ = IniControl.Value
        MemoryCaption$(ctr%) = ini_text$
    
    Next ctr%
        
    '----- We are outta here
    Exit Sub
    
read_ini_err:

    'Ini file was trashed, pop message and load defaults
    Pop_Message "Ini File Error", "Make sure that the file 'two_meter.ini' is located in the 'c:\windows' directory. If it is there already then it is damaged, replace it with a fresh copy. The program will continue using defaults."

    TunedFrequency# = 146#
    Battery_Adjust! = 1
    Scan_Delay% = 2
    sldSquelch.Value = 5
    Rssi_Gain! = 4.17
    Rssi_Offset% = 11
    
End Sub

'Save the current settings to the ini file

Sub Save_Ini()
Dim ctr%

    'Set the error handler
    On Error GoTo save_ini_err
    
    '----- Set ini file parameters
    'Setup ini control
    IniControl.filename = "two_Meter.ini"
    IniControl.Application = "TWO_METER"
    
    '-- Save last frequency
    IniControl.Parameter = "LAST_FREQUENCY"
    IniControl.Value = Format(TunedFrequency#, "###.000")
    
    '-- Save squelch setting
    IniControl.Parameter = "SQUELCH"
    IniControl.Value = Format(SquelchValue%, "###")
    
    '-- Save the options settings
    IniControl.Parameter = "BATTERY_GAIN"
    IniControl.Value = Format(Battery_Adjust!, "0.00")
    
    IniControl.Parameter = "RSSI_OFFSET"
    IniControl.Value = Format(Rssi_Offset%, "00")
    
    IniControl.Parameter = "RSSI_GAIN"
    IniControl.Value = Format(Rssi_Gain!, "0.00")
    
    IniControl.Parameter = "SCAN_DELAY"
    IniControl.Value = Format(Scan_Delay%, "00")
    
    '----- Save the memory channels
    For ctr% = 0 To 9
        IniControl.Application = "MEMORY" + Format(ctr% + 1, "0")
        
        '-- Save the frequency
        IniControl.Parameter = "FREQUENCY"
        IniControl.Value = Format(MemoryFrequency#(ctr%), "###.000")
        
        '-- Save the title
        IniControl.Parameter = "TITLE"
        IniControl.Value = MemoryCaption$(ctr%)
    Next ctr%
    
    'We are outta here
    Exit Sub

save_ini_err:

    'Nothing to do but exit
    
End Sub

'Memory scan subroutine

Private Sub cmdMemScanStart_Click()
Dim memory_channel%
Dim time_out!

    'Kill the timer
    tmrMain.Enabled = False
    
    'Kill all the other menu items
    mnuFile.Enabled = False
    mnuMode.Enabled = False
    mnuOptions.Enabled = False
    
    'Kill this control
    cmdMemScanStart.Enabled = False
    
    'Set scan mode indicator
    lblMemScan.Visible = True
    
    'Set Squelch audio mode
    optAudio_Click (AUDIO_SQUELCH)
    
    'Disable the audio block
    fraAudio.Enabled = False
    optAudio(0).Enabled = False
    optAudio(1).Enabled = False
    optAudio(2).Enabled = False
    
    'First set the scan flag
    ScanMode% = True
    
    'Initilize memory channel
    memory_channel% = 0
    
    '--- Main scanning loop
    Do While (ScanMode% = True)
        
        '--- Get channel
        
        'Make sure it is not empty
        If (MemoryFrequency#(memory_channel%) = Empty) Then
            GoTo next_memory
        End If
        
        'Set the frequency
        Set_Frequency (MemoryFrequency#(memory_channel%))
        
        'Set the caption to red when on channel
        'optMemory(memory_channel%).ForeColor = &HFF
        
        optMemory(memory_channel%).Value = True
        
        
        'Let something else happen
        DoEvents
        
        'Wait a while
        Delay_Milli_Seconds (50)
        
        'Read the receiver analog signals
        Update_Analog
        
        If RSSI% >= SquelchValue% Then
            'Got a signal -- Wait till it is gone for 2 seconds
            
            'Set the timout period
            time_out! = Timer + Scan_Delay%
            
            'Turn audio on
            Set_Audio ("N")
            
            'Wait till signal goes away
            'for 2 seconds or stop scan is pressed
            Do While time_out! > Timer
            
                'Wait a spell, ya'll
                Delay_Milli_Seconds (100)
                
                'Do a doevents
                DoEvents
                
                Update_Analog
                
                If RSSI% >= SquelchValue% Then
                    'Signal was still greater than RSSI, reset timer
                    time_out! = Timer + Scan_Delay%
                End If
                
                'Check for scan mode still being true
                If ScanMode% = False Then
                    'User pressed scan stop, so exit
                    GoTo mem_scan_xit
                End If
            
            Loop
            
            'If here, then signal timed_out
            'so set audio off
            Set_Audio ("F")
            
        Else
            'No signal, so turn audio off
            Set_Audio ("F")
        End If
        
next_memory:

        'Set the caption back to black
        'optMemory(memory_channel%).ForeColor = &H0
        
        '--- Increment to next memory channel
        memory_channel% = memory_channel% + 1
        
        If memory_channel% > 9 Then
            'Start over
            memory_channel% = 0
        End If
        
    Loop

    'We are outta here
    
mem_scan_xit:

   'Enable all the other menu items
    mnuFile.Enabled = True
    mnuMode.Enabled = True
    mnuOptions.Enabled = True
    
    'Set scan mode indicator
    lblMemScan.Visible = False

    'Set this control back to enabled
    cmdMemScanStart.Enabled = True
    
    'Set the audio fram enabled again
    fraAudio.Enabled = True
    optAudio(0).Enabled = True
    optAudio(1).Enabled = True
    optAudio(2).Enabled = True
    
    'Reset the timer
    tmrMain.Enabled = True

End Sub

'Kill the memory scan flag to stop scanning

Private Sub cmdMemScanStop_Click()
    ScanMode% = False
End Sub

'Start the scan mode

Private Sub cmdScanStart_Click()
Dim time_out!

    '----- Scan initilization ---------------------------------------
    'Kill the timer
    tmrMain.Enabled = False
    
    'Kill all the other menu items
    mnuFile.Enabled = False
    mnuMode.Enabled = False
    mnuOptions.Enabled = False
    
    'Kill this control
    cmdScanStart.Enabled = False
    
    'Set scan mode indicator
    lblScan.Visible = True
    
    'Set Squelch audio mode
    optAudio_Click (AUDIO_SQUELCH)
    
    'Disable the audio block
    fraAudio.Enabled = False
    optAudio(0).Enabled = False
    optAudio(1).Enabled = False
    optAudio(2).Enabled = False
    
    'Set ScanMode true
    ScanMode% = True
    
    '----- Scan loop ------------------------------------------------
    'As long as the ScanMode% is set we will scan
    Do While (ScanMode% = True)
        
        'Increment the frequency
        TunedFrequency# = TunedFrequency# + StepSize!
        
        'Bound frequency
        If TunedFrequency# > 148# Then
            TunedFrequency# = 144#
        End If
        
        'Set the PLL
        Set_Frequency (TunedFrequency#)
        
        'Update the display
        Display_Frequency
        
        'Read the receiver analog signals
        Update_Analog
        
        If RSSI% >= SquelchValue% Then
            'Got a signal -- Wait till it is gone for 2 seconds
            
            'Set the timout period
            time_out! = Timer + Scan_Delay%
            
            'Turn audio on
            Set_Audio ("N")
            
            'Wait till signal goes away
            'for 2 seconds or stop scan is pressed
            Do While time_out! > Timer
            
                'Wait a spell
                Delay_Milli_Seconds (50)
                
                'Do a doevents
                DoEvents
                
                Update_Analog
                
                If RSSI% >= SquelchValue% Then
                    'Signal was still greater than RSSI, reset timer
                    time_out! = Timer + Scan_Delay%
                End If
                
                'Check for scan mode still being true
                If ScanMode% = False Then
                    'User pressed scan stop, so exit
                    GoTo scan_xit
                End If
            
            Loop
            
            'If here, then signal timed_out
            'so set audio off
            Set_Audio ("F")
            
        Else
            'No signal, so turn audio off
            Set_Audio ("F")
        End If
        
    Loop

'Scan function exit here
scan_xit:

    'Enable all the other menu items
    mnuFile.Enabled = True
    mnuMode.Enabled = True
    mnuOptions.Enabled = True
    
    'Set scan mode indicator
    lblScan.Visible = False

    'Set this control back to enabled
    cmdScanStart.Enabled = True
    
    'Set the audio fram enabled again
    fraAudio.Enabled = True
    optAudio(0).Enabled = True
    optAudio(1).Enabled = True
    optAudio(2).Enabled = True
    
    'Reset the timer
    tmrMain.Enabled = True
    
End Sub

'This sets a flag that will kill manual scan mode

Private Sub cmdScanStop_Click()
    ScanMode% = False
End Sub

'----- It all starts here! -----

Private Sub Form_Load()
Dim comm_port%
Dim rval$
Dim keep_looping%
Dim found_hardware%

'Kill that damn timer!
tmrMain.Enabled = False
    
'----- Initilize globals
StepSize! = 0.01  'Set for 10 kHz scaning
ScanMode% = False

'----- Read the ini file
Read_Ini

'----- Initilize controls
'Set scan mode indicators to off
lblScan.Visible = False
lblMemScan.Visible = False

'Set manual tuning mode
fraManual.Enabled = True
fraManual.Visible = True

fraMemory.Enabled = False
fraMemory.Visible = False

'Set the menu check's
mnuManual.Checked = True
mnuMemory.Checked = False
mnuSpectrum.Checked = False
    
'----- Initilize settings
Comm_Control.Settings = "9600,N,8,1"
On Error Resume Next
    
'----- Search for Hardware
keep_looping% = True
comm_port% = 1
found_hardware% = False

Do While (keep_looping% = True) And (comm_port% <= 16)
    
    'Clear any errors
    Err.Clear
    
    'Try to open port
    Comm_Control.CommPort = comm_port%
    Comm_Control.PortOpen = True
    
    'Check for error
    If Err.Number <> 0 Then
        'This port was not valid
        'comm_port%
        GoTo next_port
    End If
        
    'Port must be open, check for hardware by
    'sending a D and looking for a *
    rval$ = Send_Command("X", True)
    
    If InStr(rval$, Chr(EOT)) > 0 Then
        'Found Hardware, get outta here
        found_hardware% = True
        Exit Do
    Else
        Comm_Control.PortOpen = False
    End If
    
next_port:
    comm_port% = comm_port% + 1
Loop
    
'comm_port% now holds the valid comm port
'if found_hardware% = true
If found_hardware% = True Then
    ConnectedTo$ = "Connected: Com 1"
Else
    'No hardware found pop message and quit
    Pop_Message "Error Finding Hardware #1", "Could not find the receiver on RS232 ports 1-16. Reset the receiver, verify the connections to a valid RS232 port and try again."
    
    'The end here will not execute the form unload
    End
End If

'We are now connected to the hardware and the port is open

'----- Setup hardware
'Update the PLL
Set_Frequency (TunedFrequency#)

'Update the audio
optAudio_Click (AUDIO_SQUELCH)

'Now set the form timer and pop the form
tmrMain.Enabled = True

End Sub

'Program exit point!

Private Sub Form_Unload(Cancel As Integer)
    
    'Turn the audio off
    Set_Audio ("F")
    
    'Save the settings to the ini file
    Save_Ini
    
    'Shut the whole app down
    End
    
    'Ta Ta For Now (TTFN)
End Sub

'This kills the program, by unloading the form!

Private Sub mnuFileExit_Click()
    Unload Me
End Sub

'Pops the about form

Private Sub mnuHelpAbout_Click()
    frmAbout.Show vbModal
End Sub

'Sets manual mode

Private Sub mnuManual_Click()
    
    'Check the menus
    mnuManual.Checked = True
    mnuMemory.Checked = False
    mnuSpectrum.Checked = False
    
    'Set the frames
    fraManual.Enabled = True
    fraManual.Visible = True
        
    fraMemory.Enabled = False
    fraMemory.Visible = False
       
    'Enable the main form timer
    tmrMain.Enabled = True
    
End Sub

'Sets memory mode

Private Sub mnuMemory_Click()
Dim ctr%

    'Kill the damn main form timer!
    tmrMain.Enabled = False
    
    'Check the menus
    mnuManual.Checked = False
    mnuMemory.Checked = True
    mnuSpectrum.Checked = False
    
    'Set the frames properly
    fraManual.Enabled = False
    fraManual.Visible = False
    
    fraMemory.Enabled = True
    fraMemory.Visible = True
    
    'Load the memory data
    'stored in memory (or that was read from the ini file)
    For ctr% = 0 To 9
        'Load the captions
        optMemory(ctr%).Caption = MemoryCaption$(ctr%)
        
        'Uncheck them all
        optMemory(ctr%).Value = False
    Next ctr%
    
    'Restart the timer
    tmrMain.Enabled = True
        
End Sub
    
'Pop the raw data display
    
Private Sub mnuRawData_Click()
    frmData.Show vbModal
End Sub

'Pop the options dialog

Private Sub mnuSetOptions_Click()
    frmOptions.Show vbModal
End Sub

'Do a spectrum display start point

Private Sub mnuSpectrum_Click()

    'kill the main form timer
    tmrMain.Enabled = False
        
    'Show the spectrum display
    frmSpectrum.Show vbModal
    
    'Back from spectrum, set the frequency back the way it was
    OldFrequency# = 0
    'Set_Frequency (TunedFrequency#)
    
    'Check the menus
    mnuManual.Checked = True
    mnuMemory.Checked = False
    mnuSpectrum.Checked = False
    
    'Set the main form timer
    tmrMain.Enabled = True
       
    'Set manual mode again
    frmMain.fraManual.Enabled = True
    frmMain.fraManual.Visible = True
        
    frmMain.fraMemory.Enabled = False
    frmMain.fraMemory.Visible = False
    
End Sub

'Set the audio mode

Private Sub optAudio_Click(Index As Integer)

    'Kill the timer
    tmrMain.Enabled = False

    Select Case Index
    
        Case 0 'Audio on
            Set_Audio ("N")
            SquelchMode% = False
            
        Case 1 'Audio off
            Set_Audio ("F")
            SquelchMode% = False
            
        Case 2 'Audio squelch
            Set_Audio ("F")
            SquelchMode% = True
        
    End Select
    
    'Reset the timer
    tmrMain.Enabled = True
    
End Sub

'Set to manual channel frequency

Private Sub optMemory_Click(Index As Integer)

    'First be sure it is valid
    If MemoryFrequency#(Index) = Empty Then
        'It was empty so display a message
        Pop_Message "Memory Not Programmed", "This memory channel is not programmed. Double click on this memory to program it."
        Exit Sub
    End If
    
    'Set the frequency (it will get updated on the next timer pulse)
    TunedFrequency# = MemoryFrequency#(Index)
    
End Sub

'Pop the set memory channel set form

Private Sub optMemory_DblClick(Index As Integer)
    
    '----- Clean up the SetMemory form first
    
    'Check to see if there is something in the memory channel first
    If MemoryFrequency#(Index) <> Empty Then
        'Yes, something was there, so display it
        frmMemorySet.medFrequency.Text = Format(MemoryFrequency#(Index), "###.000")
        frmMemorySet.medCaption.Text = MemoryCaption$(Index)
    Else
        'Nope, it was empty so kill it
        frmMemorySet.medFrequency.Text = "146.000"
        frmMemorySet.medCaption.Text = MemoryCaption$(Index)
    End If
    
    'Show the form, first make sure that the mask is set properly
    frmMemorySet.medFrequency.Mask = "###.###"
    frmMemorySet.Show vbModal
    
    'User pressed OK, so get data from SetMemory form
    'data is validated on the previous form
    
    'If frequency is set as empty then reset the values
    If Val(frmMemorySet.medFrequency.Text) = 0 Then
        'Yup, reset the channel
        MemoryCaption$(Index) = "Memory " + Str$(Index + 1)
        optMemory(Index).Caption = MemoryCaption$(Index)
        MemoryFrequency#(Index) = Empty
    Else
        'Data was set so continue
        MemoryCaption$(Index) = frmMemorySet.medCaption.Text
        optMemory(Index).Caption = MemoryCaption$(Index)
        MemoryFrequency#(Index) = CDbl(frmMemorySet.medFrequency.Text)
        
        'Set the frequency (it will get updated on the next timer pulse)
        TunedFrequency# = MemoryFrequency#(Index)
    End If
    
End Sub

'Set the scan step size

Private Sub optStep_Click(Index As Integer)

    Select Case Index
    
        Case 0  '5 kHz Step Size
            StepSize! = 0.005
        
        Case 1  '10 kHz Step Size
            StepSize! = 0.01

    End Select
    
End Sub

'Update the global squelch value

Private Sub sldSquelch_Click()
      
    'The slider runs from 0 to 100
    SquelchValue% = sldSquelch.Value

End Sub

'Click the frequency down a notch

Private Sub spnFrequency_SpinDown(Index As Integer)

    'Kill the timer
    tmrMain.Enabled = False

    Select Case (Index)
        Case 0  'kHz digit
            TunedFrequency# = TunedFrequency# - 0.005
            
        Case 1  '10 kHz digit
            TunedFrequency# = TunedFrequency# - 0.01
            
        Case 2  '100 kHz digit
            TunedFrequency# = TunedFrequency# - 0.1
            
        Case 3  '1 MHz digit
            TunedFrequency# = TunedFrequency# - 1
            
    End Select
        
    'Check to be sure the frequency is in bounds
    If TunedFrequency# < 144 Then
        TunedFrequency# = 144
    End If
    
    'Update the display
    Display_Frequency
    
    'Reset the timer
    tmrMain.Enabled = True
    
End Sub

'Click the frequency up a notch

Private Sub spnFrequency_SpinUp(Index As Integer)
    
    'Kill the timer
    tmrMain.Enabled = False
    
    Select Case (Index)
            Case 0  'kHz digit
                TunedFrequency# = TunedFrequency# + 0.005
                
            Case 1  '10 kHz digit
                TunedFrequency# = TunedFrequency# + 0.01
                
            Case 2  '100 kHz digit
                TunedFrequency# = TunedFrequency# + 0.1
                
            Case 3  '1 MHz digit
                TunedFrequency# = TunedFrequency# + 1
                
    End Select
            
    'Check to be sure the frequency is in bounds
    If TunedFrequency# > 148 Then
        TunedFrequency# = 148
    End If
        
    'Update the display
    Display_Frequency
    
    'Reset the timer
    tmrMain.Enabled = True
    
End Sub

'Main system timer

'This timer event fires every 100 mS to set the frequency (if needed)
'read the analog signals and set the audio on if it should be unsquelched

Private Sub tmrMain_Timer()
Dim dummy%

    'Set the frequency if it is not current
    If TunedFrequency# <> OldFrequency# Then
        'Update the frequency
        Set_Frequency (TunedFrequency#)
        OldFrequency# = TunedFrequency#
        
        'Update the display (only needed in manual mode)
        Display_Frequency
    End If
    
    'Update Analog Values
    Update_Analog
    
    'Check squelch mode
    If SquelchMode% = True Then
        'Yup so see if RSSI is > Squelch setting
        If RSSI% >= SquelchValue% Then
            'Yup, so set audio on
            dummy% = Set_Audio("N")
        Else
            'Nope, set audio off
            dummy% = Set_Audio("F")
        End If
    End If
    
    '---- Now update the displays
    
    'Update the signal display (RSSI is scaled at the Update_Analog procedure)
    pbSignal.Value = RSSI%
    
    'Update the battery voltage display
    sbStatusBar.Panels.Item(1) = ConnectedTo$ + "       " + "Battery = " + Format$(Battery!, "##.00") + " V"

End Sub
