VERSION 5.00
Object = "{C932BA88-4374-101B-A56C-00AA003668DC}#1.1#0"; "MSMASK32.OCX"
Begin VB.Form frmMemorySet 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Memory Channel Setup"
   ClientHeight    =   2145
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6570
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2145
   ScaleWidth      =   6570
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin MSMask.MaskEdBox medCaption 
      Height          =   255
      Left            =   960
      TabIndex        =   1
      Top             =   840
      Width           =   1575
      _ExtentX        =   2778
      _ExtentY        =   450
      _Version        =   327681
      MaxLength       =   16
      PromptChar      =   "_"
   End
   Begin MSMask.MaskEdBox medFrequency 
      Height          =   255
      Left            =   960
      TabIndex        =   0
      Top             =   240
      Width           =   855
      _ExtentX        =   1508
      _ExtentY        =   450
      _Version        =   327681
      MaxLength       =   7
      Format          =   "###.000"
      Mask            =   "###.###"
      PromptChar      =   "_"
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   3480
      TabIndex        =   2
      Top             =   1680
      Width           =   2535
   End
   Begin VB.Label Label4 
      Caption         =   $"frmMemorySet.frx":0000
      Height          =   1455
      Left            =   2880
      TabIndex        =   6
      Top             =   120
      Width           =   3375
   End
   Begin VB.Label Label3 
      Caption         =   "MHz"
      Height          =   255
      Left            =   1920
      TabIndex        =   5
      Top             =   240
      Width           =   495
   End
   Begin VB.Label Label2 
      Caption         =   "Channel Caption"
      Height          =   435
      Left            =   120
      TabIndex        =   4
      Top             =   720
      Width           =   615
   End
   Begin VB.Label Label1 
      Caption         =   "Tuned Frequency"
      Height          =   435
      Left            =   120
      TabIndex        =   3
      Top             =   240
      Width           =   780
   End
End
Attribute VB_Name = "frmMemorySet"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'=====[ Memory setup sub-form ]======================================
'Copyright information contained on About.Frm

Option Explicit

'OK from the set frequency for a memory channel

Private Sub cmdOK_Click()
    
    'Kill the mask, this prevents an error when reassigning the value
    'to the frequency text box
    medFrequency.Mask = ""
    
    'Fixup (remove) any '_' in the returned frequency text
    medFrequency.Text = Format(Val(medFrequency.Text), "###.000")
    
    'If value is 0, set the channel to empty
    If Val(medFrequency.Text) = 0 Then
        'Hide the form
        frmMemorySet.Hide
        Exit Sub
    End If
    
    'Restore the frequency mask
    medFrequency.Mask = "###.###"
    
    'Check to be sure the frequency is within range
    If (CDbl(medFrequency.Text) < 144#) Or (CDbl(medFrequency.Text) > 148#) Then
        'Nope frequency was not right
        Pop_Message "Frequency Set Error", "The frequency must between 144 and 148 MHz"
        
        'Do it again
        medFrequency.SetFocus
        Exit Sub
    
    End If
    
    'Check to be sure that the frequency is on a 5 KHz minimum
    'spacing
    If (CDbl(medFrequency.Text) * 1000 Mod 5) <> 0 Then
        'Nope frequency was not right
        Pop_Message "Frequency Set Error", "The frequency must end in 0 or 5 kHz (i.e. the step size is 5 kHz minimum)"
        
        'Do it again
        medFrequency.SetFocus
        Exit Sub
    End If
    
    'Hide the form
    frmMemorySet.Hide
    
End Sub

