VERSION 5.00
Object = "{C932BA88-4374-101B-A56C-00AA003668DC}#1.1#0"; "MSMASK32.OCX"
Begin VB.Form frmOptions 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Two Meter Receiver Setup Options"
   ClientHeight    =   5010
   ClientLeft      =   2565
   ClientTop       =   1500
   ClientWidth     =   6150
   Icon            =   "frmOptions.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5010
   ScaleWidth      =   6150
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin MSMask.MaskEdBox medGain 
      Height          =   375
      Left            =   240
      TabIndex        =   3
      Top             =   3360
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   661
      _Version        =   327681
      MaxLength       =   4
      Mask            =   "#.##"
      PromptChar      =   "_"
   End
   Begin MSMask.MaskEdBox medOffset 
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   2280
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   661
      _Version        =   327681
      MaxLength       =   2
      Mask            =   "##"
      PromptChar      =   "_"
   End
   Begin MSMask.MaskEdBox medDelay 
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Top             =   1560
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   661
      _Version        =   327681
      MaxLength       =   2
      Mask            =   "##"
      PromptChar      =   "_"
   End
   Begin MSMask.MaskEdBox medBattery 
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   661
      _Version        =   327681
      MaxLength       =   4
      Mask            =   "#.##"
      PromptChar      =   "_"
   End
   Begin VB.PictureBox picOptions 
      BorderStyle     =   0  'None
      Height          =   3780
      Index           =   3
      Left            =   -20000
      ScaleHeight     =   3780
      ScaleWidth      =   5685
      TabIndex        =   8
      TabStop         =   0   'False
      Top             =   480
      Width           =   5685
      Begin VB.Frame fraSample4 
         Caption         =   "Sample 4"
         Height          =   1785
         Left            =   2100
         TabIndex        =   11
         Top             =   840
         Width           =   2055
      End
   End
   Begin VB.PictureBox picOptions 
      BorderStyle     =   0  'None
      Height          =   3780
      Index           =   2
      Left            =   -20000
      ScaleHeight     =   3780
      ScaleWidth      =   5685
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   480
      Width           =   5685
      Begin VB.Frame fraSample3 
         Caption         =   "Sample 3"
         Height          =   1785
         Left            =   1545
         TabIndex        =   10
         Top             =   675
         Width           =   2055
      End
   End
   Begin VB.PictureBox picOptions 
      BorderStyle     =   0  'None
      Height          =   3780
      Index           =   1
      Left            =   -20000
      ScaleHeight     =   3780
      ScaleWidth      =   5685
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   480
      Width           =   5685
      Begin VB.Frame fraSample2 
         Caption         =   "Sample 2"
         Height          =   1785
         Left            =   645
         TabIndex        =   9
         Top             =   300
         Width           =   2055
      End
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   4920
      TabIndex        =   5
      ToolTipText     =   "Pressing Cancel, exits without saving."
      Top             =   4560
      Width           =   1095
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   3720
      TabIndex        =   4
      ToolTipText     =   "Pressing OK, saves these values for later use."
      Top             =   4560
      Width           =   1095
   End
   Begin VB.Line Line3 
      X1              =   120
      X2              =   6000
      Y1              =   3240
      Y2              =   3240
   End
   Begin VB.Line Line2 
      X1              =   120
      X2              =   6000
      Y1              =   2160
      Y2              =   2160
   End
   Begin VB.Line Line1 
      X1              =   120
      X2              =   6000
      Y1              =   1440
      Y2              =   1440
   End
   Begin VB.Label Label4 
      Caption         =   $"frmOptions.frx":000C
      Height          =   975
      Left            =   1680
      TabIndex        =   15
      Top             =   3360
      Width           =   4335
   End
   Begin VB.Label Label2 
      Caption         =   "Sets the scan delay in seconds. Values can range from 1 to 10 seconds. Typical value is 2 seconds."
      Height          =   495
      Left            =   1680
      TabIndex        =   13
      Top             =   1560
      Width           =   4335
   End
   Begin VB.Label Label1 
      Caption         =   $"frmOptions.frx":011C
      Height          =   1215
      Left            =   1800
      TabIndex        =   12
      Top             =   120
      Width           =   4215
   End
   Begin VB.Label Label3 
      Caption         =   $"frmOptions.frx":0281
      Height          =   855
      Left            =   1680
      TabIndex        =   14
      Top             =   2280
      Width           =   4335
   End
End
Attribute VB_Name = "frmOptions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'=====[ Receiver Options Form ]======================================
'Copyright information contained on About.Frm

Option Explicit

'Exit w/out saving

Private Sub cmdCancel_Click()
    Unload Me
End Sub

'Validate entries and save in ini file

Private Sub cmdOK_Click()

Dim batt_val!
Dim offset%
Dim gain!
Dim sc_delay%

    '----- Validate entries
    batt_val! = CSng(Val(medBattery.Text))
    If batt_val! < 0.5 Or batt_val! > 1.5 Then
        'Error, set focus on battery value and show form again
        MsgBox "Battery adjust value must be between 0.5 and 1.5", vbExclamation, "Battery adjust value error"
        medBattery.SetFocus
        Exit Sub
    Else
        'Value was good so set it
        Battery_Adjust! = batt_val!
    End If
    
    sc_delay% = CInt(Val(medDelay.Text))
    If sc_delay% < 1 Or sc_delay% > 10 Then
        'Error, set focus on scan delay value and show form again
        MsgBox "Scan delay value must be between 1 and 10", vbExclamation, "Scan delay value error"
        medDelay.SetFocus
        Exit Sub
    Else
        'Value was good so set it
        Scan_Delay% = sc_delay%
    End If
    
    offset% = CInt(Val(medOffset.Text))
    If offset% < 0 Or offset% > 50 Then
        'Error, set focus on scan delay value and show form again
        MsgBox "Rssi offset value must be between 0 and 50", vbExclamation, "Rssi offset value error"
        medOffset.SetFocus
        Exit Sub
    Else
        'Value was good so set it
        Rssi_Offset% = offset%
    End If
    
    gain! = CSng(Val(medGain.Text))
    If gain! < 2 Or gain! > 6 Then
        'Error, set focus on scan delay value and show form again
        MsgBox "Rssi gain value must be between 2.0 and 6.0", vbExclamation, "Rssi gain value error"
        medGain.SetFocus
        Exit Sub
    Else
        'Value was good so set it
        Rssi_Gain! = gain!
    End If
    
    'If here all numbers must have validated correctly
    
    'Save all the values
    frmMain.Save_Ini
    
    'Unload the form
    Unload Me

End Sub

'Load the form and initilize

Private Sub Form_Load()
    
    'Display the current values
    medBattery.Text = Format(Battery_Adjust!, "0.00")
    medOffset.Text = Format(Rssi_Offset%, "00")
    medGain.Text = Format(Rssi_Gain!, "0.00")
    medDelay.Text = Format(Scan_Delay%, "00")
        
End Sub
