VERSION 5.00
Begin VB.Form frmSpectrum 
   AutoRedraw      =   -1  'True
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Spectrum Display"
   ClientHeight    =   3195
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   8460
   ControlBox      =   0   'False
   Icon            =   "frmSpectrum.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3195
   ScaleWidth      =   8460
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton cmdRefresh 
      Caption         =   "Refresh"
      Height          =   375
      Left            =   6120
      TabIndex        =   10
      ToolTipText     =   "Clears display"
      Top             =   2760
      Width           =   855
   End
   Begin VB.Timer tmrSpectrum 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   7920
      Top             =   2280
   End
   Begin VB.Frame fraCursor 
      Caption         =   "Cursor Frequency"
      Height          =   615
      Left            =   120
      TabIndex        =   8
      ToolTipText     =   "Shows the cursor frequency"
      Top             =   2520
      Width           =   2055
      Begin VB.Label lblCursorFrequency 
         Alignment       =   2  'Center
         Caption         =   "Frequency"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         ToolTipText     =   "Shows the cursor frequency"
         Top             =   240
         Width           =   1815
      End
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Quit Spectrum"
      Height          =   375
      Left            =   7200
      TabIndex        =   7
      ToolTipText     =   "Quits the spectrum display"
      Top             =   2760
      Width           =   1215
   End
   Begin VB.PictureBox picSpectrum 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      ForeColor       =   &H0000FFFF&
      Height          =   1335
      Left            =   240
      MousePointer    =   2  'Cross
      ScaleHeight     =   100
      ScaleMode       =   0  'User
      ScaleWidth      =   4
      TabIndex        =   0
      Top             =   240
      Width           =   8055
   End
   Begin VB.Label lblFloor 
      Height          =   255
      Left            =   120
      TabIndex        =   12
      Top             =   2160
      Width           =   1215
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "Press 'Shift' and 'Click' on the display 'Peak' to tune to that frequency."
      Height          =   495
      Left            =   3000
      TabIndex        =   11
      Top             =   2640
      Width           =   2655
   End
   Begin VB.Line Line10 
      X1              =   7275
      X2              =   7275
      Y1              =   1680
      Y2              =   1800
   End
   Begin VB.Line Line9 
      X1              =   5265
      X2              =   5265
      Y1              =   1680
      Y2              =   1800
   End
   Begin VB.Line Line8 
      X1              =   3255
      X2              =   3255
      Y1              =   1680
      Y2              =   1800
   End
   Begin VB.Line Line7 
      X1              =   1245
      X2              =   1245
      Y1              =   1680
      Y2              =   1800
   End
   Begin VB.Line lineMarker 
      BorderWidth     =   2
      X1              =   2400
      X2              =   2400
      Y1              =   1680
      Y2              =   1560
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Frequency (MHz)"
      Height          =   195
      Left            =   3675
      TabIndex        =   6
      Top             =   2040
      Width           =   1215
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "148"
      Height          =   195
      Left            =   8140
      TabIndex        =   5
      Top             =   1800
      Width           =   270
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "147"
      Height          =   195
      Left            =   6130
      TabIndex        =   4
      Top             =   1800
      Width           =   270
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "146"
      Height          =   195
      Left            =   4120
      TabIndex        =   3
      Top             =   1800
      Width           =   270
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      Caption         =   "145"
      Height          =   195
      Left            =   2110
      TabIndex        =   2
      Top             =   1800
      Width           =   270
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "144"
      Height          =   195
      Left            =   100
      TabIndex        =   1
      Top             =   1800
      Width           =   270
   End
   Begin VB.Line Line6 
      X1              =   4260
      X2              =   4260
      Y1              =   1680
      Y2              =   1800
   End
   Begin VB.Line Line5 
      X1              =   6270
      X2              =   6270
      Y1              =   1680
      Y2              =   1800
   End
   Begin VB.Line Line4 
      X1              =   2250
      X2              =   2250
      Y1              =   1680
      Y2              =   1800
   End
   Begin VB.Line Line3 
      X1              =   8280
      X2              =   8280
      Y1              =   1680
      Y2              =   1800
   End
   Begin VB.Line Line2 
      X1              =   240
      X2              =   240
      Y1              =   1680
      Y2              =   1800
   End
   Begin VB.Line Line1 
      X1              =   240
      X2              =   8280
      Y1              =   1680
      Y2              =   1680
   End
End
Attribute VB_Name = "frmSpectrum"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'=====[ Spectrum Display Module ]====================================
'Copyright information contained on About.Frm

Option Explicit

'----- Local globals
Private Spectrum_Scan%  'Flag, true if scanning should continue
Private Noise_Floor!    'The calculated noise floor
Private Frequency#      'The current scan frequency

'Clear the screen and start scan over

Private Sub cmdRefresh_Click()
    
    picSpectrum.Cls
    Frequency# = 144
    picSpectrum.Line (0, 100)-(0, 100)
    
End Sub

'End the spectrum display

Private Sub cmdStop_Click()
    
    Spectrum_Scan% = False
    
End Sub

'Spectrum mode begins here!

Private Sub Form_Load()
    
    'Enable the spectrum scan flag
    Spectrum_Scan% = True
    
    'Set the start frequency and scan
    Frequency# = 144
    
    'Setup the timer
    tmrSpectrum.Interval = 10
    tmrSpectrum.Enabled = True
    
    'Initial noise floor (this number is equal to the maximum
    'RSSI offset value set in the options form)
    Noise_Floor! = 50
    
    'Clear the picture box
    picSpectrum.Cls
    
    'Initilize the graphics cursor
    picSpectrum.Line (0, 100)-(0, 100)
    
    'Set the audio off
    Set_Audio ("F")
    
End Sub

'Remove the form and turn off the local timer

Private Sub Form_Unload(Cancel As Integer)

    'Kill this forms timer
    tmrSpectrum.Enabled = False
    tmrSpectrum.Interval = 0
    
End Sub

'Revert to manual mode if mouse button is pressed and
'shift key is pressed

Private Sub picSpectrum_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
Dim freq#

    '1 = Shift key
    If Shift = 1 Then
    
        'Round to nearest 10 kHz
        freq# = CInt(X * 100) / 100
        
        'Set the tuned frequency
        TunedFrequency# = 144# + freq#
        
        'Signal the end of the scan
        Spectrum_Scan% = False
        
    End If
    
End Sub

'Show the cursor frequency when the mouse is over the picture window

Private Sub picSpectrum_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    
    'Set the label
    lblCursorFrequency.Caption = Format(144 + Str$(X), "000.00") + " MHz"
    
    'Allow for screen update
    DoEvents
    
End Sub

'On every timer, set the next frequency, get the RSSI value
'and plot it (plus a bunch of other stuff)

Private Sub tmrSpectrum_Timer()
Dim y_value%

    'Allow for screen update
    DoEvents

    'Check to see if spectrum scan has been stopped
    If Spectrum_Scan% = False Then
        'Yup, unload the form
        Unload frmSpectrum
        
        'Go back to the main form
        Exit Sub
    End If

    'Update the frequency
    Frequency# = Frequency# + 0.01  '10 kHz step
    
    'Tune the PLL
    Set_Frequency (Frequency#)
    
    'Check for roll over frequency
    If Frequency# > 148# Then
        Frequency# = 144#
        picSpectrum.Line (0, 100)-(0, 100)
    End If
    
    'Move the frequency marker
    lineMarker.X1 = ((Frequency# - 144) * (8040 / 4)) + 240
    lineMarker.X2 = ((Frequency# - 144) * (8040 / 4)) + 240
    
    'Update the analog
    Update_Analog
    
    'If the Rssi value was greater than the noise floor, then
    'delay and make a more accurate measurement
    If RSSI% > Noise_Floor! + 2 Then
        Delay_Milli_Seconds (80)
        Update_Analog
    End If
    
    'Calculate new noise floor
    If Noise_Floor! + 10 > RSSI% Then
        'Don't add signal to noise floor if it is big
        'Avg factor of RSSI to existing noise floor = 1/64
        Noise_Floor! = Noise_Floor! * 0.9844 + RSSI% * 0.0156
    End If
    
    'This is a debug statement to watch the noise floor
    'The label is already on the form (not hidden, just no
    'defult text. To get debug info just uncomment this line
    'lblFloor.Caption = Format(Noise_Floor!, "###.###")
    
    'Scale the RSSI value
    y_value% = 100 - RSSI%
    
    'Draw the line (from the previous point)
    picSpectrum.Line -(Frequency# - 144 - 0.01, y_value%)
    
End Sub
