CLS
cq$ = UCASE$(COMMAND$)
'====================================================
'dimension code character array
'====================================================
	'array for transmit character strings
	DIM c$(60)
	'array for state names and state totals
	DIM state$(50): DIM st(50)

'====================================================
'dimension menu screen arrays
'====================================================
	'arrays for saving and altering menu formats
	DIM video(1 TO 1000)  AS INTEGER
	DIM videokey(1 TO 2000)  AS INTEGER

'====================================================
'define screen coordinates for menu display blocks
'====================================================

	DIM blockp(15)
	DIM blockl(15)
	FOR n = 1 TO 13 STEP 3: blockp(n) = 10: NEXT n
	FOR n = 2 TO 14 STEP 3: blockp(n) = 223: NEXT n
	FOR n = 3 TO 15 STEP 3: blockp(n) = 436: NEXT n
	FOR n = 1 TO 3: blockl(n) = 33: NEXT n
	FOR n = 4 TO 6: blockl(n) = 49: NEXT n
	FOR n = 7 TO 9: blockl(n) = 65: NEXT n
	FOR n = 10 TO 12: blockl(n) = 81: NEXT n
	FOR n = 13 TO 15: blockl(n) = 97: NEXT n

'====================================================
'get configuration file data
'====================================================

	'error trapping if no data file is present
	'ON ERROR GOTO portio
	'if default data file is present, open file
	OPEN "cw.dat" FOR INPUT AS #1
		'get port
		INPUT #1, port
		'get your call
		INPUT #1, mycall$
		IF RIGHT$(mycall$, 1) <> " " THEN mycall$ = mycall$ + " "
		'get default speed
		INPUT #1, wpm
		'default sidetone status
		INPUT #1, st
		'default sidetone freq
		INPUT #1, shz
		'get custom cq
		INPUT #1, custom$
		'get memory 1 text
		INPUT #1, mem1$
		'get memory 2 text
		INPUT #1, mem2$
		'get weighting factor
		INPUT #1, wf$: wf = VAL(wf$)
		'get machine speed constant
		INPUT #1, c
		'close file
		CLOSE #1

configloop:

'====================================================
'prepare calls lookup table
'====================================================

OPEN "log.dat" FOR INPUT AS #1
n = 1
DO UNTIL EOF(1)
	GOSUB readentry
	n = n + 1
	LOOP
	CLOSE #1

x = n + 100
DIM call$(x)
FOR n = 1 TO x: call$(n) = "*": NEXT n

OPEN "log.dat" FOR INPUT AS #1
n = 1
DO UNTIL EOF(1)
	GOSUB readentry
	call$(n) = call$
	n = n + 1
	LOOP
	CLOSE #1
	z = n - 1

'====================================================
'begin program code
'====================================================
begin:

	keydown = 1
	'port value for key down
	keyup = 0
	'port value for key-up
	CLS
'====================================================
'set up morse character array
'====================================================
	RESTORE
	FOR n = 1 TO 58
		READ c$(n)
		NEXT n

	FOR n = 1 TO 50
		READ state$(n)
		st(n) = 0
		NEXT n

'====================================================
'set output port parameters
'====================================================
	'configure keying output port
	OUT port, keyup
       
	'define receiving input port
	rport = port + 2
       
	'set up receive port
	OUT rport, 0
       
	'read value for your input port (will vary from
	'one machine to another
	x = INP(rport)
       
	'if the port value is even, this is the toneoff value on receive
	'and toneon will be toneoff + 1
	IF (x / 2) = INT(x / 2) THEN toneoff = x: toneon = x + 1: GOTO outset1
       
	'if the value was odd, it becomes toneon and toneoff =
	'toneon - 1
	toneon = x: toneoff = x - 1
outset1:

'====================================================
'calibrate sending speed
'====================================================
calspeed:
       
	'if value of c <> 6000 than a valid speed constant
	'is available and speed calibration can be bypassed
	IF c <> 6000 GOTO calspeed3
       
	'save default speed and set to 30 wpm for calibration test
	oldwpm = wpm
	wpm = 30
       
	'save default port and set to dummy port so transmitter
	'is not keyed during the test
	oldport = port
	port = port + 1
       
	'dummy valuefor percent speed error
	percent = 0
	'initial calibration run
	crun = 0
calspeed1:
	x$ = "CALIBRATING TRANSMIT SPEED": GOSUB post
	PRINT
	PRINT
	'compute screen value for error from percent
	IF crun = 0 THEN GOTO calspeed1a
	p = 1 - percent: p = p * 10000: p = INT(p): p = p / 100
       
	'print error is not prior to first run
calspeed1a:
	IF crun <> 0 THEN PRINT "Run "; crun; " error = "; p; " %" ELSE PRINT
	PRINT
       
	'post for 3 seconds
	begtime = TIMER
calspeedd:
	endtime = TIMER
	time = endtime - begtime
	IF time < 3 THEN GOTO calspeedd

	'calibrate sending clock
	GOSUB clock
       
	'test text - should take 2 sec at 30 wpm
	send$ = "PARIS"
	PRINT
       
	'start timing
	begtime = TIMER
       
	'send the test text
	GOSUB sendstring
       
	'stop timing
	endtime = TIMER
       
	'compute time to send text
	time = endtime - begtime
       
	'calculate the error in transmit time
	percent = time / 2
	IF percent = 0 THEN percent = .1

	'if error less than +/- 2% then move on
	IF (percent < 1.02) AND (percent > .98) THEN GOTO calspeed2
       
	'if error exceeds +/- 2% recalibrate value for c
	c = INT(c / percent)
       
	'increment calibration run count
	crun = crun + 1
       
	'repeat calibration test
	GOTO calspeed1

calspeed2:
	'reset speed to default
	wpm = oldwpm
       
	'reset port to default
	port = oldport

calspeed3:
	'calibrate sending clock
	GOSUB clock
       
	'starting menu block
	block = 14

	'call lookup token off
	lookup = 0

'====================================================
'Main Menu
'====================================================

main:
       
	'set screen mode
	SCREEN 2
       
	'screen-saving status
	scrn$ = "ON"
       
	'define text window
	VIEW PRINT 1 TO 25: scrnstat = 0
       
	'do main menu text
	CLS
	x$ = "WB8DQT MORSE PROGRAM Ver. 2.0 (c) 1994": GOSUB post
	PRINT
	PRINT
	PRINT "     Mycall:                        OPTIONS                     QUIT"
	PRINT
	PRINT "       Port:                  Sidetone:                   Frequency:          "
	PRINT
	PRINT "  Custom CQ:                  Memory 1:                    Memory 2:        "
	PRINT
	PRINT "     Weight:                         SAVE                        HELP       "
	PRINT
	PRINT "       Keyboard                Working:                       Speed:"
	PRINT
	PRINT "   <F1> ABORT SENDING           <F2> 3 x 3 CQ             <F3> Custom CQ"
	PRINT
	PRINT "   <F4> Call                    <F5> Comeback             <F6> Over"
	PRINT
	PRINT "   <F7> Memory 1                <F8> Memory 2             <F9> CW Receive"
	LOCATE 21, 1
	PRINT "Use Arrow keys to position highlighted block, followed by <ENTER> to enable.."

	'do main menu graphics
       
	'horizontal lines
	LINE (0, 20)-(639, 20)
	LINE (0, 36)-(639, 36)
	LINE (0, 52)-(639, 52)
	LINE (0, 68)-(639, 68)
	LINE (0, 84)-(639, 84)
	LINE (0, 100)-(639, 100)
	LINE (0, 101)-(639, 101)
	LINE (0, 116)-(639, 116)
	LINE (0, 132)-(639, 132)
	LINE (0, 148)-(639, 148)
	LINE (0, 149)-(639, 149)

	'vertical lines
	LINE (213, 20)-(213, 148)
	LINE (214, 20)-(214, 148)
	LINE (426, 20)-(426, 148)
	LINE (427, 20)-(427, 148)

	LOCATE 16, 14: IF othercall$ = "" THEN PRINT "QRZ" ELSE PRINT othercall$

	'save keyboard options portion of screen display
	GET (0, 101)-(639, 148), videokey
       
	'print your call
	LOCATE 4, 14: PRINT mycall$
       
	'post other station's call if available
	LOCATE 12, 41: IF othercall$ = "" THEN PRINT "NONE" ELSE PRINT othercall$
       
	'post current speed setting
	LOCATE 12, 69: PRINT STR$(wpm) + " WPM"
       
	'post current port
	LOCATE 6, 14: PRINT HEX$(port) + "h"
       
	'post sidetone status
	LOCATE 6, 41: IF st = 0 THEN PRINT "OFF" ELSE PRINT "ON"
       
	'post sidetone frequency
	LOCATE 6, 69: PRINT STR$(shz) + " Hz"
       
	'post custom cq status
	LOCATE 8, 14: IF custom$ = "" THEN PRINT "EMPTY" ELSE PRINT "LOADED"
       
	'post memory 1 status
	LOCATE 8, 41: IF mem1$ = "" THEN PRINT "EMPTY" ELSE PRINT "LOADED"
       
	'post memory 2 status
	LOCATE 8, 70: IF mem2$ = "" THEN PRINT "EMPTY" ELSE PRINT "LOADED"
       
	'post weighting factor
	LOCATE 10, 14: PRINT wf$
       
	'activate current menu block
	GOSUB blockon
       
	'default on othercall block
	IF block = 13 THEN GOTO keybd


'====================================================
'main menu options
'====================================================
main0:
	'get keyboard input
	GOSUB kbio
       
	'if screen has been blanked while waiting for keyboard
	'input, go back and re-do main manu display
	IF scrn$ = "OFF" THEN GOTO main

main1:
	'arrow key inputs
	IF (q$ = "UP") AND (block > 3) THEN GOSUB blockoff: block = block - 3: GOSUB blockon
	IF (q$ = "DOWN") AND (block < 13) THEN GOSUB blockoff: block = block + 3: GOSUB blockon
	IF q$ = "RIGHT" THEN GOSUB blockoff: block = block + 1: GOSUB blockon
	IF q$ = "LEFT" THEN GOSUB blockoff: block = block - 1: GOSUB blockon
	 IF block = 13 THEN GOTO keybd
	'<ENTER> key input
	IF q$ = "ENTER" THEN GOTO mainr
	GOTO main0

mainr:
	'activate options based on current block value
	'your call
	IF block = 1 THEN LOCATE 4, 14: PRINT "          ": GOTO mycall
	
	'other stations call
	IF block = 14 THEN LOCATE 12, 41: PRINT "          ": GOTO othercall
       
	'speed
	IF block = 15 THEN LOCATE 12, 69: PRINT "       ": LOCATE 12, 69: INPUT x: GOSUB speed: GOTO main
       
	'port
	IF block = 4 THEN GOTO portsel
       
	'sidetone status
	IF block = 5 THEN GOTO sidetonetoggle
       
	'sidetone frequency
	IF block = 6 THEN LOCATE 6, 69: PRINT "        ": LOCATE 6, 69: INPUT x: GOTO sidetonefreq
       
	'quit program
	IF block = 3 THEN CLS : SCREEN 0: SYSTEM
       
	'memory 1 text
	IF block = 8 THEN GOSUB loadmem1: GOTO main
       
	'memory 2 text
	IF block = 9 THEN GOSUB loadmem2: GOTO main
       
	'custom cq text
	IF block = 7 THEN GOTO custom
       
	'options
	IF block = 2 THEN GOTO options
       
	'save setup data
	IF block = 11 THEN GOTO defaults
       
	'help options
	IF block = 12 THEN GOTO help
       
	'weighting input
	IF block = 10 THEN GOTO weight
       
	'return to keyboard scan
	GOTO main0

'====================================================
' turn-over to other station - exits to keyboard
'====================================================
comeback:
	send$ = othercall$ + "DE " + mycall$ + " "
	GOSUB sendstring
	RETURN

'====================================================
'custom cq data entry
'====================================================
custom:
	CLS
	GOSUB header
	x$ = "INPUT CUSTOM CQ FORMAT": GOSUB post
	PRINT
	PRINT "PRESENT TEXT:"
	PRINT "=============================================================================="
	PRINT
	PRINT custom$
	PRINT
	PRINT "=============================================================================="
	PRINT
	PRINT
	x$ = "Input text for custom CQ (<C> to clear, <Q> for no change....": GOSUB post
	PRINT
	INPUT text$: CLS
	text$ = UCASE$(text$)
	IF text$ = "C" THEN custom$ = "": GOTO main
	IF text$ = "Q" THEN GOTO main
	custom$ = text$: GOTO main

'====================================================
'saves all valid input material as default set-up
'====================================================
defaults:
	OPEN "cw.dat" FOR OUTPUT AS #1
		'port value
		WRITE #1, port
		'your call
		WRITE #1, mycall$
		'default speed
		WRITE #1, wpm
		'default sidetone status
		WRITE #1, st
		'default sidetome frequency
		WRITE #1, shz
		'default custom cq text
		WRITE #1, custom$
		'default memory 1 text
		WRITE #1, mem1$
		'default memory 2 text
		WRITE #1, mem2$
		'default weighting factor
		WRITE #1, wf$
		'default clock constant
		WRITE #1, c
		CLOSE #1
		GOTO main0

'====================================================
'On-line help options
'====================================================

help:
	SCREEN 0
	CLS
	x$ = "** HELP FILE OPTIONS **": GOSUB post
	PRINT
	x$ = "Main Menu Functions": GOSUB post
	x$ = "   <M>ycall             <O>ptions           <Q>uit        ": GOSUB post
	PRINT
	x$ = "   <P>ort               S<I>detone          <F>requency   ": GOSUB post
	PRINT
	x$ = "   <C>ustom CQ          Memory <1>          Memory <2>    ": GOSUB post
	PRINT
	x$ = "   W<E>ight             S<A>ve              <H>elp        ": GOSUB post
	PRINT
	x$ = "   <K>eyboard           <W>orking           <S>peed       ": GOSUB post
	PRINT
	x$ = "<*> Special Characters": GOSUB post
	PRINT
	x$ = "Keyboard Functions": GOSUB post
	x$ = "   <F1> Abort Sending   <F2> 3 x 3 CQ       <F3> Custom CQ": GOSUB post
	PRINT
	x$ = "   <F4> Call            <F5> Comeback       <F6> Over     ": GOSUB post
	PRINT
	x$ = "   <F7> Memory 1        <F8> Memory 2       <F9> CW RCV   ": GOSUB post
	PRINT
	x$ = "   <F10> Exit HELP      <+> Log QSO                       ": GOSUB post
	PRINT
	x$ = "Hit indicated key for function...": GOSUB post
	head$ = ""
helpr:
	GOSUB kbio
	IF q$ = "M" THEN head$ = "Mycall"
	IF q$ = "O" THEN head$ = "Options"
	IF q$ = "Q" THEN head$ = "Quit"
	IF q$ = "P" THEN head$ = "Port"
	IF q$ = "I" THEN head$ = "Sidetone"
	IF q$ = "F" THEN head$ = "Frequency"
	IF q$ = "C" THEN head$ = "Custom CQ"
	IF q$ = "1" THEN head$ = "Memory 1"
	IF q$ = "2" THEN head$ = "Memory 2"
	IF q$ = "E" THEN head$ = "Weight"
	IF q$ = "A" THEN head$ = "Save"
	IF q$ = "H" THEN head$ = "Help"
	IF q$ = "K" THEN head$ = "Keyboard"
	IF q$ = "W" THEN head$ = "Working"
	IF q$ = "S" THEN head$ = "Speed"
	IF q$ = "F1" THEN head$ = "Abort Sending"
	IF q$ = "F2" THEN head$ = "3 x 3 CQ"
	IF q$ = "F3" THEN head$ = "Send Custom CQ"
	IF q$ = "F4" THEN head$ = "Call"
	IF q$ = "F5" THEN head$ = "Comeback"
	IF q$ = "F6" THEN head$ = "Over"
	IF q$ = "F7" THEN head$ = "Send Memory 1"
	IF q$ = "F8" THEN head$ = "Send Memory 2"
	IF q$ = "F9" THEN head$ = "CW Receive"
	IF q$ = "F12" THEN head$ = "Log QSO"
	IF q$ = "*" THEN head$ = "Special Characters"
	IF q$ = "F10" THEN SCREEN 2: CLS : GOTO main
	IF head$ = "" THEN GOTO helpr
	CLS
       
	'open the help text data file
	OPEN "cwhelp.dat" FOR INPUT AS #1
help2:
	'scan the file data looking for matches between the input
	'data (d$) and the subject header (head$)
	INPUT #1, d$
	IF d$ <> head$ THEN GOTO help2
       
	'post the header text to the screen
	x$ = d$: GOSUB post
	PRINT
help3:
	'print text lines from the data file until the text is END
	INPUT #1, d$
	IF d$ = "END" THEN GOTO help4
	PRINT d$
	GOTO help3
help4:
	'close the help text data file
	CLOSE #1
	PRINT
	PRINT
	x$ = "Hit any key to return to HELP Menu...": GOSUB post
	GOSUB kbio
	GOTO help

'====================================================
'cw keyboard general data entry
'====================================================
keybd:
	GOSUB posttime
       
	'define restricted text window at the bottom of screen
	VIEW PRINT 21 TO 25: scrnstat = 1
       
	'clear the text window
	CLS 2
       
	'set up F1 as abort hot key
	ON KEY(1) GOSUB abort
	KEY(1) ON
       
	'activate keyboard options section of menu
	PUT (0, 101), videokey, PRESET
	IF lookup = 1 THEN GOSUB shortcallsearch
keybdr:
	'wait for keyboard input
	GOSUB kbio
       
	'if screen has blanked during the wait, kill the abort
	'hot key and return to the main menu routine to restore
	'the screen
	IF scrn$ = "OFF" THEN KEY(1) OFF: GOTO main
       
	'branch if a function key
	IF LEN(q$) > 1 THEN GOTO keybd2
       
	'set the transmit string to the current keyboard character
	'send the transmit string
	'on return, check for a function key
	IF q$ = "[" THEN q$ = "\KN"
	IF q$ = "]" THEN q$ = "\SK"
	IF q$ = "{" THEN q$ = "\AR"
	IF q$ = "}" THEN q$ = "\AS"
	IF q$ = "|" THEN q$ = "\AA"
	send$ = q$: GOSUB sendstring: IF LEN(q$) = 2 THEN GOSUB kbio1: GOTO keybd2
	GOTO keybdr
keybd2:
	'call standard cq
	IF q$ = "F2" THEN GOSUB callcq: CLS 2: GOTO keybdr
       
	'call custom cq
	IF q$ = "F3" THEN GOSUB callcustom: CLS 2: GOTO keybdr
       
	'call station
	IF q$ = "F4" THEN GOSUB callhim: CLS 2: GOTO keybdr
       
	'exchange preface
	IF q$ = "F5" THEN GOSUB comeback:
       
	'exchange terminate
	IF q$ = "F6" THEN GOSUB over: PRINT
       
	'insert break
	IF q$ = "F7" THEN GOSUB mem1
       
	'send message 1
	IF q$ = "F8" THEN GOSUB mem2
       
	'send message 2
	IF q$ = "F9" THEN GOSUB receive
       
	'log current qso data
	IF q$ = "F12" THEN GOSUB logit
       
	'check for arrow keys
	IF (q$ = "UP") OR (q$ = "DOWN") OR (q$ = "LEFT") OR (q$ = "RIGHT") THEN GOTO keybdexit
	GOTO keybdr

keybdexit:
	'reset active window
	VIEW PRINT 1 TO 25: scrnstat = 0
       
	'deactivate abort error trapping
	KEY(1) OFF
       
	'deactivate keyboard options menu display
	PUT (0, 101), videokey, PSET
       
	GOTO main1

'====================================================
'load memory 1 text
'====================================================

loadmem1:
	CLS
	temp$ = ""
	GOSUB header
	x$ = "LOAD MEMORY 1": GOSUB post
	PRINT
	PRINT "============================================================================"
	x$ = "CURRENT TEXT FOR MEMORY 1": GOSUB post
	PRINT
	PRINT mem1$
	PRINT
	PRINT "============================================================================"
	PRINT
	x$ = "Key new text for Memory 1 (<*> to clear or <F1> to quit)...": GOSUB post
	PRINT
	PRINT
	VIEW PRINT 21 TO 25: scrnstat = 1
loadmem1r:
	q$ = INKEY$: IF q$ = "" THEN GOTO loadmem1r
	IF q$ = "*" THEN mem1$ = "": GOTO loadmem1x
	IF LEN(q$) = 2 THEN GOTO loadmem12
	IF ASC(q$) = 8 THEN BEEP: y = LEN(temp$) - 1: temp$ = LEFT$(temp$, y): CLS 2: PRINT temp$; : GOTO loadmem1r
	q$ = UCASE$(q$)
	CLS 2: temp$ = temp$ + q$: PRINT temp$: GOTO loadmem1r
loadmem12:
	IF temp$ = "" THEN GOTO loadmem1x
	mem1$ = temp$
loadmem1x:
	 VIEW PRINT 1 TO 25: scrnstat = 0
	CLS
	RETURN
	       
'====================================================
'load memory 2 text
'====================================================

loadmem2:
	CLS
	temp$ = ""
	GOSUB header
	x$ = "LOAD MEMORY 2": GOSUB post
	PRINT
	PRINT "============================================================================"
	x$ = "CURRENT MEMORY 2 TEXT": GOSUB post
	PRINT
	PRINT mem2$
	PRINT
	PRINT "============================================================================"
	PRINT
	x$ = "Key new text for Memory 2 (<*> to clear or <F1> to quit)...": GOSUB post
	PRINT
	PRINT
	VIEW PRINT 21 TO 25: scrnstat = 1
loadmem2r:
	q$ = INKEY$: IF q$ = "" THEN GOTO loadmem2r
	IF q$ = "*" THEN mem2$ = "": GOTO loadmem2x
	IF LEN(q$) = 2 THEN GOTO loadmem22
	IF ASC(q$) = 8 THEN BEEP: CLS 2: y = LEN(temp$) - 1: temp$ = LEFT$(temp$, y): PRINT temp$; : GOTO loadmem2r
	q$ = UCASE$(q$)
	CLS 2: : temp$ = temp$ + q$: PRINT temp$: GOTO loadmem2r
loadmem22:
	IF temp$ = "" THEN GOTO loadmem2x
	mem2$ = temp$
loadmem2x:
	VIEW PRINT 1 TO 25: scrnstat = 0
	CLS
	RETURN

'====================================================
'send contents of memory 1
'====================================================
mem1:
	send$ = mem1$
	GOSUB sendstring
	PRINT
	GOTO keybdr

'====================================================
'send contents of memory 2
'====================================================
mem2:
	send$ = mem2$
	GOSUB sendstring
	PRINT
	GOTO keybdr

'====================================================
'input your call
'====================================================

mycall:
	mycall$ = ""
mycallr:
	LOCATE 4, 14
	PRINT "          "
	LOCATE 4, 14
	PRINT mycall$
	GOSUB kbio
	IF q$ = "ENTER" THEN GOTO mycallx
	IF q$ = "BACK" THEN BEEP: a = LEN(mycall$) - 1: mycall$ = LEFT$(mycall$, a): GOTO mycallr
	IF LEN(q$) = 1 THEN mycall$ = mycall$ + q$
	IF LEN(mycall$) > 10 THEN mycall$ = ""
	GOTO mycallr
mycallx:
	IF mycall$ = "" THEN mycall$ = "EMPTY " ELSE mycall$ = mycall$ + " "
	GOTO main

'====================================================
'input other call
'====================================================

othercall:
	othercall$ = ""
othercallr:
	LOCATE 12, 41
	PRINT "          "
	LOCATE 12, 41
	PRINT othercall$
	GOSUB kbio
	IF q$ = "ENTER" THEN GOTO othercallx
	IF q$ = "BACK" THEN BEEP: a = LEN(othercall$) - 1: othercall$ = LEFT$(othercall$, a): GOTO othercallr
	IF LEN(q$) = 1 THEN othercall$ = othercall$ + q$
	IF LEN(othercall$) > 10 THEN othercall$ = "": GOTO othercallr
	GOTO othercallr
othercallx:
	IF othercall$ = "" THEN othercall$ = "QRZ ": GOTO othercallxx
	c$ = othercall$
	othercall$ = othercall$ + " "
	lookup = 1
	ltyme$ = LEFT$(TIME$, 5)
	lday$ = LEFT$(DATE$, 6) + RIGHT$(DATE$, 2)
othercallxx:
	block = 13
	GOTO main

'====================================================
'set first-run defaults if no cw.dat file is present
'====================================================
portio:
	port = &H378
	mycall$ = ""
	wpm = 14
	st = 0
	shz = 800
	custom$ = ""
	mem1$ = ""
	mem2$ = ""
	wf$ = "1": wf = 1
	c = 6000
	GOTO begin

'====================================================
'port select routine
'====================================================
portsel:
	CLS
	GOSUB header
	x$ = "PORT SELECT": GOSUB post
	PRINT
	x$ = "Current port = " + HEX$(port) + "h": GOSUB post
	PRINT
	PRINT
	x$ = "<1> Port = 3BCh            ": GOSUB post
	PRINT
	x$ = "<2> Port = 378h            ": GOSUB post
	PRINT
	x$ = "<3> Port = 278h            ": GOSUB post
	PRINT
	x$ = "<Q>uit With No Change      ": GOSUB post
	PRINT
	x$ = "Enter desired option...": GOSUB post
portselr:
	q$ = INKEY$: IF q$ = "" THEN GOTO portselr
	q$ = UCASE$(q$)
	IF q$ = "1" THEN port = &H3BC: OUT (port), keyup: GOTO main
	IF q$ = "2" THEN port = &H378: OUT (port), keyup: GOTO main
	IF q$ = "3" THEN port = &H278: OUT (port), keyup: GOTO main
	IF q$ = "Q" THEN GOTO main
	GOTO portselr

'====================================================
'call qrz - branch option when using C<A>ll option
'when no call is present in the <W>orking slot
'====================================================
qrz:
	send$ = "QRZ QRZ DE " + mycall$ + mycall$ + "\AR "
	GOSUB sendstring
	RETURN

'====================================================
'toggle sidetone state
'====================================================

sidetonetoggle:
	IF st = 0 THEN st = 1 ELSE st = 0
	GOTO main

'====================================================
'reset sidetone frequency
'====================================================
sidetonefreq:
	IF x < 400 THEN x = 400
	IF x > 1200 THEN x = 1200
	shz = INT(x + .5)
sidetonefreqx:
	GOTO main
	       
'====================================================
'misc. options
'====================================================

options:
	CLS
	GOSUB header
	x$ = "MISCELLANEOUS OPTIONS": GOSUB post
	PRINT
	PRINT
	x$ = "<T>une Transmitter    ": GOSUB post
	PRINT
	x$ = "<L>ogging Functions   ": GOSUB post
	PRINT
	x$ = "<C>alibrate Speed     ": GOSUB post
	PRINT
	PRINT
	x$ = "Key desired option or <Q> to quit....": GOSUB post
optionsr:
	GOSUB kbio
	IF q$ = "Q" THEN GOTO main
	IF q$ = "T" THEN GOTO tune
	IF q$ = "L" THEN GOTO logger
	IF q$ = "C" THEN c = 6000: CLS : GOTO calspeed
	GOTO optionsr

'====================================================
'key transmitter routine
'====================================================
tune:
	CLS
	GOSUB header
	x$ = "KEY TRANSMITTER": GOSUB post
	PRINT
	PRINT
	OUT port, keydown
	x$ = "Hit any key to return to Main Menu....": GOSUB post
tuner:
	q$ = INKEY$: IF q$ = "" THEN GOTO tuner
	OUT port, keyup
	GOTO main

'====================================================
'weighting adjustment
'====================================================
weight:
	CLS
	GOSUB header
	x$ = "WEIGHTING SELECT": GOSUB post
	PRINT
	PRINT
	PRINT "Current weight factor = "; wf$
	PRINT
	PRINT
	INPUT "New weight factor (0.50 to 1.50) or <Q> to quit"; wf$: CLS
	wf = VAL(wf$)
	IF wf < .5 THEN wf = .5
	IF wf > 1.5 THEN wf = 1.5
	wf$ = STR$(wf)
	x = LEN(wf$)
	wf$ = RIGHT$(wf$, x - 1)
	IF wf < 1 THEN wf$ = "0" + wf$
	GOSUB clock
	GOTO main
       
'====================================================================
'SUBROUTINES - ARRANGED ALPHA-ORDER
'====================================================================

abort:
	q$ = INKEY$: IF q$ <> "" THEN GOTO abort
	q$ = " "
	send$ = " "
	OUT port, keyup
	CLS 2
	RETURN

blockoff:
	p = blockp(block)
	l = blockl(block)
	l = l - 10
	v = POINT(p, l)
	IF v = 0 THEN GOTO blockoffr
	PUT (p, l), video, PSET
blockoffr:
	RETURN

blockon:
	IF block = 0 THEN block = 15
	IF block = 16 THEN block = 1
	p = blockp(block)
	l = blockl(block)
	l = l - 10
	v = POINT(p, l)
	IF v = 1 THEN GOTO blockonr
	GET (p, l)-(p + 193, l + 9), video
	PUT (p, l), video, PRESET
blockonr:
	RETURN

'====================================================
'call the other station
'====================================================
callhim:
	IF othercall$ = "" THEN GOTO qrz
	send$ = othercall$ + othercall$ + "DE " + mycall$ + mycall$ + "\AR "
	GOSUB sendstring
	RETURN

'====================================================
'return to other station
'====================================================
over:
	send$ = othercall$ + "DE " + mycall$ + "\KN "
	GOSUB sendstring
	RETURN

'====================================================
'call custom cq from keyboard
'====================================================
callcustom:
	send$ = custom$
	GOSUB sendstring
	IF cq$ <> "AUTO" THEN GOTO callcustomx
	CLS 2
	tr = 30: PRINT tr
	ts = TIMER
callcustomr:
	q$ = INKEY$: IF q$ <> "" THEN GOTO callcustomx
	te = TIMER
	tl = INT(te - ts)
	tl = 30 - tl
	IF tl <> tr THEN CLS 2: tr = tl: PRINT tr
	IF tr = 0 THEN CLS 2: GOTO callcustom
	GOTO callcustomr
callcustomx:
	RETURN

'====================================================
'call cq from keyboard
'====================================================
callcq:
	send$ = "CQ CQ CQ DE " + mycall$ + mycall$ + mycall$ + "K "
	GOSUB sendstring
	IF cq$ <> "AUTO" THEN GOTO callcqx
	CLS 2
	ts = TIMER
	tr = 30: PRINT tr
callcqr:
	q$ = INKEY$: IF q$ <> "" THEN GOTO callcqx
	te = TIMER
	tl = INT(te - ts)
	tl = 30 - tl
	IF tl <> tr THEN CLS 2: tr = tl: PRINT tr
	IF tr = 0 THEN CLS 2: GOTO callcq
	GOTO callcqr
callcqx:
	RETURN

'====================================================
'inter-character transmit routine
'====================================================
char:
	FOR t = 1 TO (3 * clk)
	NEXT t
	RETURN

'====================================================
'clock speed calculation
'====================================================
clock:
	chz = wpm / 1.2
	clk = INT(c / chz)
	tdot = INT(clk * wf)
	tspace = (2 * clk) - tdot
	tdash = (2 * clk) + tdot
	RETURN

'====================================================
'dash transmit routine
'====================================================
dash:
	IF st = 1 THEN SOUND shz, 50
	OUT port, keydown
	FOR t = 1 TO tdash
	NEXT t
	OUT port, keyup
	IF st = 1 THEN SOUND shz, 0
	FOR t = 1 TO tspace
	NEXT t
	RETURN

'====================================================
'morse character decode
'====================================================
decode:
	sum = 1
	x = LEN(c$)
	IF x = 1 THEN GOTO decode1
	IF x = 2 THEN GOTO decode2
	IF x = 3 THEN GOTO decode3
	IF x = 4 THEN GOTO decode4
	IF x = 5 THEN GOTO decode5
	IF x = 6 THEN GOTO decode6
	d$ = "X": GOTO decodex
decode1:
	IF c$ = "." THEN d$ = "E" ELSE d$ = "T"
	GOTO decodex
decode2:
	x$ = "IANM"
	IF LEFT$(c$, 1) = "-" THEN sum = sum + 2
	IF RIGHT$(c$, 1) = "-" THEN sum = sum + 1
	d$ = MID$(x$, sum, 1)
	GOTO decodex
decode3:
	x$ = "SURWDKGO"
	IF LEFT$(c$, 1) = "-" THEN sum = sum + 4
	IF MID$(c$, 2, 1) = "-" THEN sum = sum + 2
	IF RIGHT$(c$, 1) = "-" THEN sum = sum + 1
	d$ = MID$(x$, sum, 1)
	GOTO decodex
decode4:
	x$ = "HVF*L*PJBXCYZQ**"
	IF LEFT$(c$, 1) = "-" THEN sum = sum + 8
	IF MID$(c$, 2, 1) = "-" THEN sum = sum + 4
	IF MID$(c$, 3, 1) = "-" THEN sum = sum + 2
	IF RIGHT$(c$, 1) = "-" THEN sum = sum + 1
	d$ = MID$(x$, sum, 1)
	GOTO decodex
decode5:
	x$ = "54*3***2*******16-/*****7***8*90"
	IF LEFT$(c$, 1) = "-" THEN sum = sum + 16
	IF MID$(c$, 2, 1) = "-" THEN sum = sum + 8
	IF MID$(c$, 3, 1) = "-" THEN sum = sum + 4
	IF MID$(c$, 4, 1) = "-" THEN sum = sum + 2
	IF RIGHT$(c$, 1) = "-" THEN sum = sum + 1
	d$ = MID$(x$, sum, 1)
	GOTO decodex
decode6:
	IF LEFT$(c$, 1) = "-" THEN sum = sum + 32
	IF MID$(c$, 2, 1) = "-" THEN sum = sum + 16
	IF MID$(c$, 3, 1) = "-" THEN sum = sum + 8
	IF MID$(c$, 4, 1) = "-" THEN sum = sum + 4
	IF MID$(c$, 5, 1) = "-" THEN sum = sum + 2
	IF RIGHT$(c$, 1) = "-" THEN sum = sum + 1
	IF sum = 52 THEN d$ = ",": GOTO decodex
	IF sum = 22 THEN d$ = ".": GOTO decodex
	IF sum = 13 THEN d$ = "?": GOTO decodex
	d$ = "*"
decodex:
	PRINT d$;
	RETURN

'====================================================
'debounce delay routine
'====================================================

debounce:
	count = 0
	dcount = INT(rclk / 2)
	FOR z = 1 TO dcount
		q$ = INKEY$: IF q$ <> "" THEN GOTO debouncex
		k = INP(rport)
		IF k = 0 THEN GOTO debouncex
		count = count + 1
	NEXT z
debouncex:
	RETURN

'====================================================
'dot transmit routine
'====================================================
dot:
	IF st = 1 THEN SOUND shz, 50
	OUT port, keydown
	FOR t = 1 TO tdot
	NEXT t
	OUT port, keyup
	IF st = 1 THEN SOUND shz, 0
	FOR t = 1 TO tspace
	NEXT t
	RETURN

'====================================================
'universal program header
'====================================================
header:
	CLS
	x$ = "******************************": GOSUB post
	x$ = "*    WB8DQT MORSE PROGRAM    *": GOSUB post
	x$ = "*     Ver. 2.0  (c) 1995     *": GOSUB post
	x$ = "*    Dr. Ralph E. Taggart    *": GOSUB post
	x$ = "******************************": GOSUB post
	PRINT
	RETURN

'====================================================
'input call of station being worked
'====================================================
hiscall:
	LOCATE 11, 34
	PRINT "          "
	LOCATE 11, 34
	INPUT othercall$
	othercall$ = othercall$ + " "
	f$ = "ON"
	RETURN
       
'====================================================
'functions assigns the long strin values to q$
'====================================================

functions:
	q$ = RIGHT$(q$, 1)
	v = ASC(q$)
	IF v = 60 THEN q$ = othercall$ + othercall$ + othercall$ + "DE " + mycall$ + mycall$ + mycall$ + "K "
	IF v = 61 THEN q$ = custom$
	IF v = 62 THEN q$ = "QRZ QRZ DE " + mycall$ + mycall$ + "\AR "
	IF v = 63 THEN q$ = othercall$ + "DE " + mycall$
	IF v = 64 THEN q$ = othercall$ + "DE " + mycall$ + "\KN "
	IF v = 65 THEN q$ = "\BK "
	IF v = 66 THEN q$ = mem1$
	IF v = 67 THEN q$ = mem2$
	RETURN

'====================================================
'kbio is the general purpose menu/keyboard input
'====================================================

kbio:
	t1 = TIMER
kbio0:
	GOSUB posttime

	t2 = TIMER: IF (t2 - t1) >= 350 THEN GOTO kbio2
	q$ = INKEY$: IF q$ = "" THEN GOTO kbio0
	t1 = TIMER
	IF LEN(q$) = 2 THEN GOTO kbio1
	IF ASC(q$) = 8 THEN q$ = "BACK"
	IF ASC(q$) = 13 THEN q$ = "ENTER"
	q$ = UCASE$(q$)
	IF q$ = "+" THEN q$ = "F12"
	GOTO kbiox
kbio1:
	q$ = RIGHT$(q$, 1)
	v = ASC(q$)
	IF v = 59 THEN q$ = "F1": GOTO kbiox
	IF v = 60 THEN q$ = "F2": GOTO kbiox
	IF v = 61 THEN q$ = "F3": GOTO kbiox
	IF v = 62 THEN q$ = "F4": GOTO kbiox
	IF v = 63 THEN q$ = "F5": GOTO kbiox
	IF v = 64 THEN q$ = "F6": GOTO kbiox
	IF v = 65 THEN q$ = "F7": GOTO kbiox
	IF v = 66 THEN q$ = "F8": GOTO kbiox
	IF v = 67 THEN q$ = "F9": GOTO kbiox
	IF v = 68 THEN q$ = "F10": GOTO kbiox
	IF v = 133 THEN q$ = "F11": GOTO kbiox
	IF v = 134 THEN q$ = "F12": GOTO kbiox
	IF v = 72 THEN q$ = "UP": GOTO kbiox
	IF v = 80 THEN q$ = "DOWN": GOTO kbiox
	IF v = 77 THEN q$ = "RIGHT": GOTO kbiox
	IF v = 75 THEN q$ = "LEFT": GOTO kbiox
	GOTO kbio
kbio2:
	CLS
kbio3:
	q$ = INKEY$: IF q$ = "" THEN GOTO kbio3
	scrn$ = "OFF"
kbiox:
	RETURN

'====================================================
'check for previous contact
'====================================================

logchk:
	CLS
	hit = 0
	lday$ = LEFT$(DATE$, 6)
	lday$ = lday$ + RIGHT$(DATE$, 2)
	ltyme$ = LEFT$(TIME$, 5)
	'on error GOTO makelog
	OPEN "log.dat" FOR INPUT AS #1
	DO UNTIL EOF(1)
		INPUT #1, call$, name$, city$, state$, day$, tyme$, report$, note$
		lc = LEN(othercall$) - 1
		IF call$ = LEFT$(othercall$, lc) THEN GOSUB logprint
		LOOP
	CLOSE #1
	CLS
	RETURN
logprint:
	IF hit > 0 THEN GOTO logprintx
	log$ = name$ + "  " + call$ + "  " + city$ + ", " + state$
logprintx:
	hit = hit + 1
	BEEP
	RETURN

logit:
	IF (othercall$ = "") OR (othercall$ = "QRZ ") THEN GOTO logitr
	OPEN "temp.dat" FOR APPEND AS #1
	lc = LEN(othercall$) - 1
	call$ = LEFT$(othercall$, lc)
	PRINT #1, call$
	PRINT #1, "?"
	PRINT #1, "?"
	PRINT #1, "?"
	PRINT #1, lday$
	PRINT #1, ltyme$
	PRINT #1, "?"
	PRINT #1, "?"
	CLOSE #1
logitr:
	RETURN

'====================================================
'string parsing subroutine to extract individual characters
'====================================================
parse:
	x = LEN(x$)
	FOR n = 1 TO x
		m$ = MID$(x$, n, 1)
		IF m$ = "." THEN GOSUB dot: GOTO parsenext
		GOSUB dash
parsenext:
		NEXT n
		GOSUB char
		RETURN
	    
'====================================================
'routine to center printed text
'====================================================
post:
	l = LEN(x$)
	l = INT(l / 2)
	x = 40 - l
	PRINT TAB(x); x$
	RETURN

'====================================================
'receive main menu
'====================================================
receive:
	CLS 2
	PRINT "RECEIVE: ";

		'formula for zenith laptop
'rclk = INT((50 / wpm) * 31.5)
		'general formula
'rclk = INT((50 / wpm) * rcf)

rclk = INT((50 / wpm) * (c / 100))

'====================================================================
'readcode inputs and reads the morese characters until interrupted by
'any keystroke, at which point reception is suspended with several
'prompt options
'====================================================================

readcode:
		'====================================================
		'wait for the start of a character while checking
		'for keyboard input
		'====================================================
	q$ = INKEY$: IF q$ <> "" THEN GOTO readstop
	k = INP(rport)
	IF k = toneoff THEN GOTO readcode
		'====================================================
		'zero time count and set null for character string
		'====================================================
	count = 0
	c$ = ""
	GOSUB debounce
readcode1:
		'====================================================
		'wait until element is complete
		'====================================================
	q$ = INKEY$: IF q$ <> "" THEN GOTO readstop
	k = INP(rport)
	IF k = toneoff THEN GOTO readcode2
	count = count + 1
	GOTO readcode1
readcode2:
		'====================================================
		'determine if element was a dot or dash and add to
		'character string
		'====================================================
	IF count > (2 * rclk) THEN c$ = c$ + "-": x = (12 * rclk) + count: rclk = INT(x / 15): GOTO readcode3
	c$ = c$ + ".": x = (4 * rclk) + count: rclk = INT(x / 5)
readcode3:
	GOSUB debounce
readcode4:
	q$ = INKEY$: IF q$ <> "" THEN GOTO readstop
	k = INP(rport)
		'====================================================
		'if new element, look for more
		'====================================================
	IF k = toneon THEN count = 0: GOTO readcode1
	count = count + 1
		'====================================================
		'check to see if character complete - if so, post
		'====================================================
	IF count > (2 * rclk) THEN GOSUB decode: GOTO readcode5
	GOTO readcode4
		'====================================================
		'evaluate if word
		'====================================================
readcode5:
	q$ = INKEY$: IF q$ <> "" THEN GOTO readstop
	k = INP(rport)
		'====================================================
		'check for new word/element
		'====================================================
	count = count + 1
		'====================================================
		'check for end of word
		'====================================================
	IF count > (4 * rclk) THEN PRINT " "; : GOTO readcode
	IF k = toneon THEN GOTO readcode
	GOTO readcode5

readstop:
		CLS 2
		RETURN

'====================================================
'send single character
'====================================================
sendchar:
	'ON ERROR GOTO errortrap
	IF q$ = "\" THEN GOTO sendchar2
	n = ASC(q$)
	IF n < 32 THEN GOTO sendcharx
	'PRINT q$;
	IF n = 32 THEN GOSUB word: GOTO sendcharx
	IF n > 90 THEN GOTO sendchar2
	n = n - 32
	x$ = c$(n)
sendchar1:
	GOSUB parse
sendcharx:
	abort$ = ""
	RETURN
sendchar2:
	x$ = " "
	a = LEN(send$)
	send$ = RIGHT$(send$, a - 1)
	q$ = LEFT$(send$, 2)
	q1$ = LEFT$(q$, 1)
	q2$ = RIGHT$(q$, 1)
	a = LEN(send$)
	send$ = RIGHT$(send$, a - 2)
	n = ASC(q1$)
	n = n - 32
	y$ = c$(n)
	n = ASC(q2$)
	n = n - 32
	z$ = c$(n)
	x$ = y$ + z$
	GOTO sendchar1

sendchar3:
	x$ = ""
	IF q$ = "[" THEN x$ = "-.--."
	IF q$ = "]" THEN x$ = "...-.-"
	IF q$ = "{" THEN x$ = ".-.-."
	IF q$ = "}" THEN x$ = ".-..."
	GOTO sendchar1

errortrap:
	n = 0
	RESUME NEXT

'====================================================
'general-purpose routine to dissect a text string,
'code each character, and send it
'====================================================
sendstring:
	CLS 2
	PRINT send$
sendstring0:
	q$ = LEFT$(send$, 1)
	'IF q$ = "*" THEN q$ = f$: GOTO sendstringx
	GOSUB sendchar
	a = LEN(send$)
	IF a = 1 THEN send$ = "" ELSE send$ = RIGHT$(send$, a - 1)
	CLS 2
	PRINT send$
sendstring1:
	q$ = INKEY$
	IF (q$ = "") AND (send$ = "") THEN GOTO sendstringx
	IF q$ = "" THEN GOTO sendstring0
	IF LEN(q$) = 2 THEN GOSUB functions: GOTO sendstring1a
	q$ = UCASE$(q$)
	IF ASC(q$) = 8 THEN GOTO sendstring2
	IF ASC(q$) > 90 THEN GOTO sendstring3
sendstring1a:
	send$ = send$ + q$: GOTO sendstring1
sendstring2:
	a = LEN(send$)
	send$ = LEFT$(send$, a - 1)
	CLS 2
	PRINT send$
	GOTO sendstring0
sendstring3:
	IF q$ = "[" THEN q$ = "\KN"
	IF q$ = "]" THEN q$ = "\SK"
	IF q$ = "{" THEN q$ = "\AR"
	IF q$ = "}" THEN q$ = "\AS"
	send$ = send$ + q$
	GOTO sendstring0
sendstringx:
	t1 = TIMER
	RETURN

'====================================================
'speed set
'====================================================
speed:
	IF x < 5 THEN x = 5
	IF x > 60 THEN x = 60
	wpm = INT(x + .5)
	GOSUB clock
speedx:
	RETURN

'====================================================
'read log entries from disk
'====================================================

scanlog:
	INPUT #1, d$, t$, b$, c$, r$, n$, qth$, nts$
	RETURN

'====================================================
'display log data
'====================================================

displaylog:
	CLS
	GOSUB header
	x$ = "LOG DATA DISPLAY": GOSUB post
	PRINT
	PRINT
	PRINT "                   Date: "; d$
	PRINT "                   Time: "; t$
	PRINT "                   Band: "; b$
	PRINT "                   Call: "; c$
	PRINT "                    RST: "; r$
	PRINT "                   Name: "; n$
	PRINT "                    QTH: "; qth$
	PRINT "                  Notes: "; nts$
	PRINT
	PRINT
	x$ = "Key <Q> to quit or any other key to continue....": GOSUB post
	RETURN

'====================================================
'benchmark cpu data rate
'====================================================
test:
	beg = TIMER
	FOR c = 1 TO tcount
		NEXT c
		nd = TIMER
		time = nd - beg
		c = tcount / time
		c = INT(c)
		RETURN
	       
'====================================================
'inter-word transmit routine
'====================================================
word:
	FOR t = 1 TO (4 * clk)
	NEXT t
	RETURN

'======================================================
'log search options
'======================================================

logger:
	CLS
	GOSUB header
	x$ = "LOG SEARCH OPTIONS:": GOSUB post
	PRINT
	x$ = "1 - Search by CALL          ": GOSUB post
	x$ = "2 - Search by STATE/COUNTRY ": GOSUB post
	x$ = "3 - Search by DATE          ": GOSUB post
	x$ = "4 - Search for DX           ": GOSUB post
	x$ = "5 - Search by NOTES         ": GOSUB post
	x$ = "6 - Print Log               ": GOSUB post
	x$ = "7 - State Totals            ": GOSUB post
	x$ = "8 - Finish Entries          ": GOSUB post
	x$ = "0 - Quit Log                ": GOSUB post
	PRINT
	PRINT
	x$ = "Input desired option....": GOSUB post
logr:
	q$ = INKEY$: IF q$ = "" THEN GOTO logr
	IF q$ = "0" THEN CLS : GOTO main
	IF q$ = "1" THEN GOTO callsearch
	IF q$ = "2" THEN GOTO statesearch
	IF q$ = "3" THEN GOTO datesearch
	IF q$ = "4" THEN GOTO dx
	IF q$ = "5" THEN GOTO notesearch
	'IF q$ = "6" THEN GOTO printit
	IF q$ = "7" THEN GOTO tally
	IF q$ = "8" THEN GOTO logedit
	GOTO logr

'=====================================================
'fill in empty record fields for log entries
'=====================================================

logedit:
	'ON ERROR GOTO logerror
	OPEN "temp.dat" FOR INPUT AS #1
	OPEN "log.dat" FOR APPEND AS #2
	DO UNTIL EOF(1)
	GOSUB readentry
	GOSUB loglist
	PRINT #2, call$
	PRINT #2, name$
	PRINT #2, city$
	PRINT #2, state$
	PRINT #2, day$
	PRINT #2, tyme$
	PRINT #2, report$
	PRINT #2, note$
	call$(z) = call$: z = z + 1
	LOOP
	CLOSE #1
	CLOSE #2
	KILL "temp.dat"
	GOTO logger
       
'=====================================================
'list log entries that require record data
'=====================================================

loglist:
	CLS
	GOSUB header
	x$ = "<LOG ENTRY>": GOSUB post
	PRINT
	PRINT "<1>    DATE: "; : IF day$ <> "" THEN PRINT day$: GOTO loglist1
	INPUT day$: GOTO loglist
loglist1:
	PRINT "<2>    TIME: "; : IF tyme$ <> "" THEN PRINT tyme$: GOTO loglist2
	INPUT tyme$: GOTO loglist
loglist2:
	PRINT "<3>    CALL: "; : IF call$ <> "" THEN PRINT call$: GOTO loglist3
	INPUT call$: call$ = UCASE$(call$): GOTO loglist
loglist3:
	PRINT "<4>    NAME: "; : IF name$ <> "" THEN PRINT name$: GOTO loglist4
	INPUT name$: name$ = UCASE$(name$): GOTO loglist
loglist4:
	PRINT "<5>    CITY: "; : IF city$ <> "" THEN PRINT city$: GOTO loglist5
	INPUT city$: city$ = UCASE$(city$): GOTO loglist
loglist5:
	PRINT "<6>   STATE: "; : IF state$ <> "" THEN PRINT state$: GOTO loglist6
	INPUT state$: state$ = UCASE$(state$): GOTO loglist
loglist6:
	PRINT "<7> REPORTS: "; : IF report$ <> "" THEN PRINT report$: GOTO loglist7
	INPUT report$: report$ = UCASE$(report$): GOTO loglist
loglist7:
	PRINT "<8>   NOTES: "; : IF note$ <> "" THEN PRINT note$: GOTO loglist8
	INPUT note$: note$ = UCASE$(note$): GOTO loglist
loglist8:
	PRINT
	PRINT
	x$ = "Key item to change or <0> to accept...": GOSUB post
	GOSUB kbio
	'save the qso data
	IF q$ = "0" THEN GOTO loglist9
       
	'change the date
	IF q$ = "1" THEN day$ = "": GOTO loglist
       
	'change the time
	IF q$ = "2" THEN tyme$ = "": GOTO loglist
       
	'change the call
	IF q$ = "3" THEN call$ = "": GOTO loglist
       
	'add the name
	IF q$ = "4" THEN name$ = "": GOTO loglist
       
	'add the city
	IF q$ = "5" THEN city$ = "": GOTO loglist
       
	'add the state/country
	IF q$ = "6" THEN state$ = "": GOTO loglist
       
	'add the report
	IF q$ = "7" THEN report$ = "": GOTO loglist
       
	'add notes
	IF q$ = "8" THEN note$ = "": GOTO loglist
       
	GOTO loglist
loglist9:
	CLS
	RETURN

'=====================================================
'error trapping if no temporary qso files
'=====================================================

logerror:
	GOSUB header
	x$ = "There are no records to update!": GOSUB post
	PRINT
	PRINT
	x$ = "Hit any key to continue...": GOSUB post
logerror1:
	GOSUB kbio
	RESUME logger

'=====================================================
'short search for call
'=====================================================

shortcallsearch:
	'ON ERROR GOTO makelog
	y = 1
scs:
	IF c$ = call$(y) THEN BEEP: GOTO shortcallsearch0
	IF call$(y) = "*" THEN GOTO shortcallsearch2
	y = y + 1: GOTO scs
shortcallsearch0:
	OPEN "log.dat" FOR INPUT AS #1
	DO UNTIL EOF(1)
	GOSUB readentry
	IF c$ = call$ THEN GOSUB display ELSE GOTO shortcallsearch1
shortcallsearch1:
	LOOP
	CLOSE #1
shortcallsearch2:
	lookup = 0
	RETURN

'=====================================================
'search log data for a specific call
'=====================================================

callsearch:
	CLS
	hit = 0
	INPUT "Call to search"; c$
	IF c$ = "" THEN GOTO logger
	c$ = UCASE$(c$)
callsearch0:
	'ON ERROR GOTO makelog
	OPEN "log.dat" FOR INPUT AS #1
	DO UNTIL EOF(1)
	GOSUB readentry
	IF c$ = call$ THEN BEEP: GOSUB fulldisplay ELSE GOTO callsearch1
callsearch1:
	LOOP
	CLOSE #1
	IF lookup = 1 THEN lookup = 0: RETURN
	GOSUB hold
	hit = 0
	GOTO callsearch

'=====================================================
'search log data for a specific state/country
'=====================================================

statesearch:
	CLS
	INPUT "State/country to search (2 letter for state)"; s$
	IF s$ = "" THEN GOTO logger
	s$ = UCASE$(s$)
	GOSUB logheader
	'ON ERROR GOTO makelog
	OPEN "log.dat" FOR INPUT AS #1
	DO UNTIL EOF(1)
	GOSUB readentry
	IF s$ = state$ THEN GOSUB display
	LOOP
	CLOSE #1
	GOSUB hold
	GOTO statesearch

'=====================================================
'search notes field for a specific string
'=====================================================

notesearch:
	CLS
	hit = 0
	INPUT "String to locate"; s$: CLS
	IF s$ = "" THEN GOTO logger
	s$ = UCASE$(s$)
	s = LEN(s$)
	GOSUB logheader
	'ON ERROR GOTO makelog
	OPEN "log.dat" FOR INPUT AS #1
	DO UNTIL EOF(1)
	GOSUB readentry
	c = 1
	IF LEN(note$) < s THEN GOTO notesearch1
	z = LEN(note$)
	z = z - (s - 2)
	FOR n = 1 TO z
		IF MID$(note$, n, s) = s$ THEN GOSUB display
		NEXT n
		IF hit = 20 THEN GOSUB hold: CLS
notesearch1:
	LOOP
	CLOSE #1
	GOSUB hold
	GOTO notesearch


'=====================================================
'search for dx - any entry in state field that is not
'two letters in length
'=====================================================

dx:
	GOSUB logheader
	'ON ERROR GOTO makelog
	OPEN "log.dat" FOR INPUT AS #1
	DO UNTIL EOF(1)
	GOSUB readentry
	IF LEN(state$) > 2 THEN GOSUB display
	LOOP
	CLOSE #1
	GOSUB hold
	GOTO logger

'=====================================================
'search for all entries from a specific date
'=====================================================

datesearch:
	CLS
	INPUT "Date to search (MM-DD-YY)"; d$
	CLS
	IF d$ = "" THEN GOTO logger
	'ON ERROR GOTO makelog
	OPEN "log.dat" FOR INPUT AS #1
	DO UNTIL EOF(1)
	GOSUB readentry
	IF d$ = day$ THEN GOSUB display
	LOOP
	CLOSE #1
	GOSUB hold
	GOTO datesearch

'=====================================================
'compute QSO totals by state
'=====================================================

tally:
	CLS
	GOSUB header
	PRINT
	PRINT
	x$ = "Working on state totals....": GOSUB post
	FOR n = 1 TO 50
	st(n) = 0
	NEXT n
	t = 0
	ON ERROR GOTO makelog
	OPEN "log.dat" FOR INPUT AS #1
	DO UNTIL EOF(1)
	GOSUB readentry
	FOR n = 1 TO 50
		IF state$(n) = state$ THEN st(n) = st(n) + 1
		NEXT n
	t = t + 1
	LOOP
	CLOSE #1
	CLS
	GOSUB header
	x$ = "<STATE TOTALS>": GOSUB post
	PRINT
	PRINT
	FOR n = 1 TO 50
	IF st(n) <> 0 THEN PRINT state$(n) + " - "; st(n),  ELSE PRINT state$(n) + " - ",
	NEXT n
	PRINT
	x$ = "Total QSOs: " + STR$(t): GOSUB post
	hit = 10
	GOSUB hold
	GOTO logger

'=====================================================
'standard subroutine to read a log record
'=====================================================

readentry:
	INPUT #1, call$, name$, city$, state$, day$, tyme$, report$, note$
	RETURN

'=====================================================
'routine to display a log record
'=====================================================

display:
	PRINT day$; TAB(10); tyme$; TAB(16); call$; TAB(26); name$; TAB(36); city$ + ", " + state$; TAB(60); report$
	hit = hit + 1
	RETURN

'=====================================================
'full log record display
'=====================================================

fulldisplay:
	IF hit <> 0 THEN GOTO fdis1:
	CLS
	PRINT "  CALL: "; call$
	PRINT "  NAME: "; name$
	PRINT "   QTH: "; city$; ", "; state$
	PRINT "  DATE: "; day$
	PRINT "  TIME: "; tyme$; " Z"
	PRINT "REPORT: "; report$
	PRINT " NOTES: "; note$
	PRINT
	hit = 1
	GOTO fdis2
fdis1:
	PRINT day$, tyme$, report$
fdis2:
	RETURN

	

'=====================================================
'routine to print the log header
'=====================================================

logheader:
	CLS
	PRINT "DATE"; TAB(10); "TIME"; TAB(16); "CALL"; TAB(26); "NAME"; TAB(36); "QTH"; TAB(60); "REPORT"
	PRINT
	RETURN

'=====================================================
'error trap if log.dat file is missing
'=====================================================

makelog:
	OPEN "log.dat" FOR APPEND AS #1
	PRINT #1, "CALL"
	PRINT #1, "NAME"
	PRINT #1, "CITY"
	PRINT #1, "STATE"
	PRINT #1, "DATE"
	PRINT #1, "TIME"
	PRINT #1, "REPORT"
	PRINT #1, "NOTES"
	CLOSE #1
	OPEN "log.dat" FOR INPUT AS #1
	RESUME NEXT

'=====================================================
'routine pauses until any key is hit
'=====================================================

hold:
	IF hit = 0 THEN GOTO holdx
	PRINT
	IF hit = 20 THEN x$ = "Hit any key to continue...." ELSE x$ = "Hit any key to exit...."
	GOSUB post
holdr:
	q$ = INKEY$: IF q$ = "" THEN GOTO holdr
holdx:
	hit = 0
	RETURN

posttime:
	IF scrnstat = 1 THEN VIEW PRINT 1 TO 25
	IF dte$ <> DATE$ THEN LOCATE 1, 1: PRINT DATE$: dte$ = DATE$
	IF watch$ <> LEFT$(TIME$, 5) THEN watch$ = LEFT$(TIME$, 5): LOCATE 1, 70: PRINT watch$ + " UTC"
	IF scrnstat = 1 THEN VIEW PRINT 21 TO 25
	RETURN

	       
		'====================================================
		'ASCI-ordered CW character data
		'====================================================

' ASCI code  33  = character ! no code
DATA ""
' ASCI code  34  = character " \AF
DATA ".-..-."
' ASCI code  35  = character # no code
DATA ""
' ASCI code  36  = character $
DATA "...-..-"
' ASCI code  37  = character % no code
DATA ""
' ASCI code  38  = character & no code
DATA ""
' ASCI code  39  = character '
DATA ".----."
' ASCI code  40  = character ( \KN
DATA "-.--."
' ASCI code  41  = character ) \KK
DATA "-.--.-"
' ASCI code  42  = character * no code
DATA ""
' ASCI code  43  = character + no code
DATA ""
' ASCI code  44  = character ,
DATA "--..--"
' ASCI code  45  = character -
DATA "-...-"
' ASCI code  46  = character .
DATA ".-.-.-"
' ASCI code  47  = character /
DATA "-..-."
' ASCI code  48  = character 0
DATA "-----"
' ASCI code  49  = character 1
DATA ".----"
' ASCI code  50  = character 2
DATA "..---"
' ASCI code  51  = character 3
DATA "...--"
' ASCI code  52  = character 4
DATA "....-"
' ASCI code  53  = character 5
DATA "....."
' ASCI code  54  = character 6
DATA "-...."
' ASCI code  55  = character 7
DATA "--..."
' ASCI code  56  = character 8
DATA "---.."
' ASCI code  57  = character 9
DATA "----."
' ASCI code  58  = character :
DATA "---..."
' ASCI code  59  = character ; \KR
DATA "-.-.-."
' ASCI code  60  = character < no code
DATA ""
' ASCI code  61  = character = \BT
DATA "-...-"
' ASCI code  62  = character > no code
DATA ""
' ASCI code  63  = character ?
DATA "..--.."
' ASCI code  64  = character @ no code
DATA ""
' ASCI code  65  = character A
DATA ".-"
' ASCI code  66  = character B
DATA "-..."
' ASCI code  67  = character C
DATA "-.-."
' ASCI code  68  = character D
DATA "-.."
' ASCI code  69  = character E
DATA "."
' ASCI code  70  = character F
DATA "..-."
' ASCI code  71  = character G
DATA "--."
' ASCI code  72  = character H
DATA "...."
' ASCI code  73  = character I
DATA ".."
' ASCI code  74  = character J
DATA ".---"
' ASCI code  75  = character K
DATA "-.-"
' ASCI code  76  = character L
DATA ".-.."
' ASCI code  77  = character M
DATA "--"
' ASCI code  78  = character N
DATA "-."
' ASCI code  79  = character O
DATA "---"
' ASCI code  80  = character P
DATA ".--."
' ASCI code  81  = character Q
DATA "--.-"
' ASCI code  82  = character R
DATA ".-."
' ASCI code  83  = character S
DATA "..."
' ASCI code  84  = character T
DATA "-"
' ASCI code  85  = character U
DATA "..-"
' ASCI code  86  = character V
DATA "...-"
' ASCI code  87  = character W
DATA ".--"
' ASCI code  88  = character X
DATA "-..-"
' ASCI code  89  = character Y
DATA "-.--"
' ASCI code  90  = character Z
DATA "--.."



'=====================================================
'state two-letter abbreviation file
'=====================================================

DATA "AK","AL","AR","AZ","CA","CO","CT","DE","FL","GA","HW","IA","ID"
DATA "IL","IN","KS","KY","LA","MA","MD","ME","MI","MN","MO","MS","MT"
DATA "NC","ND","NE","NH","NJ","NM","NV","NY","OH","OK","OR","PA","RI"
DATA "SC","SD","TN","TX","UT","VA","VT","WA","WI","WV","WY"



END

