
;------------PIC_SWR.ASM---------------------------------------------
;For auto adjusting SWR meter using 16C71 by Bert Kelley May 19, 1999
;                  (Forward + Reverse)
;Executes formula:  ----------------- = SWR in units + remainder (REM)
;                  (Forward - Reverse)
;                                     
;                                       (REM X 10) 
;Extracts 1/10's SWR units from REM: -----------------= Tenths SWR
;                                   (Forward - Reverse)        
;
	list	p=16c71
	__config  0x3ff1
        radix	hex
        errorlevel -302
;-----------------------
indf	equ	0x00    ;part of indirect addr
pc	equ	0x02    ;program counter
porta	equ	0x05    ;
portb	equ	0x06    ;
status	equ	0x03    ; 
rp0	equ	5       ;bank switch bit
c	equ	0       ;carry flag    
z	equ	2       ;z flag bit
w	equ	0       ;w register
f	equ	1       ;file
fsr	equ	0x04    ;indirect pointer
adcon0	equ	0x08    ;a/d control register
adres	equ	0x09    ;holds result a to d
intcon	equ	0x0b    ;not used         
trisa	equ	0x85    ;bank 1 porta
trisb	equ	0x86    ;bank 1 portb
adcon1	equ	0x88    ;a/d control register
;variables
addrsav	equ	0x0c    ;
count	equ	0x0d    ;utilty counter  
ncount	equ	0x0e    ;holds 1 millisec delay 
mcount	equ	0x0f    ;delay
temp    equ     0x10    ;chkpwr, convert
fwd     equ     0x11    ;forward power from A/D
rev     equ     0x12    ;reverse power from A/D
fprlo   equ	0x13    ;lsb result of add F + R
fprhi   equ     0x14    ;msb result of add F + R         
fminusr equ     0x15    ;result of fwd minus rev
swrlo   equ	0x16    ;F + R/F - R remainder    
swrhi   equ     0x17    ;F + R/F - R quot./dec Msd              
prodlo  equ     0x18    ;product low from call rh_dgt
prodhi  equ     0x19    ;product high from call rh_dgt
dendhi  equ     0x1a    ;dividend high in division call
dendlo  equ     0x1b    ;dividend low in division call
dvsrlo  equ	0x1c    ;divisor in division call
tenths  equ     0x1d    ;holds swr tenths in bcd
;used by display             
dsplsd  equ     0x24    ;7 seg swr tenths to display
dspmsd  equ	0x25    ;7 seg swr units to display
;--------------------------
	org	0x000
;
start   bsf	status,rp0 ;switch to bank 1
        movlw   0x03       ;configure ports               
	movwf	trisa      ;porta set
	movlw	0x00       ;portb set all outputs
	movwf	trisb
	movlw	0x02       ;Port A bits 0,1 a/d inputs
	movwf	adcon1     ;bits 2,3,4 digital
	bcf	status,rp0 ;switch back to bank0
	clrf	portb      ;clear output port
	bcf	intcon,7   ;disable interrupt
;-------FORWARD POWER ACQUISITION--
getfwd   		  
      	movlw	0x81       ;config A/D, select AN0
	movwf	adcon0     ;
	call	del_20     ;wait 20 microseconds
	bsf	adcon0,2   ;start conversion
test	btfsc	adcon0,2   ;test for go/done bit
	goto	test       ;
	movf	adres,w    ;get conversion,
        movwf	fwd        ;                           
 	goto    chkpwr     ;
;-------CHECK INPUT POWER--
chkpwr  movf	fwd,0     ;                    
        movwf	temp      ;       
      	movlw	0x20	  ;
  	subwf	temp,f    ;
 	btfsc	status,0  ;                          
	goto    getrev    ;
	movlw	0x38      ;seven seg for "L"
        movwf	dspmsd    ;to table
        movlw   0x73      ;seven seg for "P"
        movwf   dsplsd    ;to table
	call	display   ;display "LP"
	goto	getfwd    ;resample                  
;-------REVERSE POWER ACQUISTION------
getrev  movlw	0x89      ;turn on AN1
	movwf	adcon0    ;
 	call	del_20    ;
	bsf	adcon0,2  ;
testagn btfsc	adcon0,2  ;
	goto    testagn   ;
	movf	adres,w   ; 
	movwf	rev       ;reverse stored
        goto	add_sub   ;
;-------PROCESS FORWARD & REVERSE------
add_sub clrf	fprhi     ;add F + R, (Fwd + Rev)-->fprhi,
	clrf	fprlo     ;fprlo.  (Fwd - Rev)-->fminus r.
        movf	rev,w     ;                                       
	movwf	fprlo	  ;
        movf	fwd,w     ;                           
	addwf	fprlo,f   ;
	btfsc	status,c  ;                                 
	incf	fprhi,f   ;F+R-->fprhi,fprlo
        movf    rev,w     ;Subtract Fwd - Rev-->fminusr
	subwf	fwd,w     ;                                 
        movwf   fminusr   ;setup for division to follow
 	movwf	dvsrlo    ;
	movf	fprhi,w   ;
        movwf   dendhi    ;
        movf    fprlo,w   ;
        movwf   dendlo    ;
                          ;
	call	divide    ;(F+R) divided by (F-R)            
	movf	dendlo,w  ;Quotient in dendlo, rem. in dendhi
	movwf   swrhi     ;swrhi in bcd if < 10 decimal
	movf	dendhi,w  ; 
	movwf	swrlo     ;
        goto    convert   ;
;-------CONVERT HI & LO SWR FOR DISPLAY---
convert	movlw	0x0a      ;converts tenths swr to bcd    
 	movwf	count     ;multiply swrlo by 0ah =
        clrf    prodhi    ;  --> prodhi and prodlo
 	clrf	prodlo    ;multiply by adding,
 	movf    swrlo,w   ;remainder is added 0a
mpy   	addwf	prodlo,f  ;times.                               
 	btfsc   status,c  ;
        goto    inc_hi
tally	decfsz	count,f   ;decrement multiplier
 	goto	mpy         
        goto    bcd       ;when multiplication finished                                 
        ;
inc_hi	incf	prodhi,f  ;count carrys
 	goto	tally
        ;
bcd   	movf	prodhi,w  ;divides prodhi,lo by fminusr
	movwf   dendhi    ;
        movf    prodlo,w  ;
        movwf   dendlo    ;
        movf    fminusr,w ;
        movwf   dvsrlo    ;
        call    divide    ;(SWRLO X A)/(FMINUSR)=BCD TENTHS
	movf    dendlo,w  ;dendlo in divide holds answer,
        movwf   tenths    ;is swr digit to right of dp
	movlw	0x0a      ;check if swr is over 10
        subwf	swrhi,w   ;
	btfsc	status,c  ;
	goto    hi_swr    ;over, show message on display
        clrw              ;
	movf	swrhi,w	  ;                                
    	call    segmnt    ;convert to 7 segment
	movwf   dspmsd    ;
        bsf     dspmsd,7  ;set decimal point
	clrf	dsplsd    ;
        movf	tenths,w  ;
   	call    segmnt    ;
        movwf   dsplsd    ;
exit                      ;conversions ready for display
        ;
       	call	display   ;two digit display, turn off 
 	goto	getfwd    ;                       
;
hi_swr  movlw	0x76      ;H to
 	movwf   dspmsd    ;display MSD
        movlw   0x06      ;I  (HI for high SWR)
        movwf   dsplsd    ;to display LSD                   
        goto    exit      ;
                          ;
;-Divide program written by Bob Fehrenbach, from
;http://members.tripod,com/~mdileo/snippic.html 
;
divide  movlw   0x08
	movwf	count  
	clrf	temp      ;temp holds borrow
divloop rlf	dendlo,f  ;16 bit lsd's in dendlo
	rlf	dendhi,f  ;16 bit msd's in dendhi
	rlf	temp,f    
	movf	dvsrlo,w  ;8 bit divisor
	subwf	dendhi,w
	btfss	temp,0    
	skpnc	
	movwf	dendhi
	btfsc	temp,0   
	rrf	temp,f
	decfsz	count,f
	goto	divloop   ;quotient in dendlo
	rlf	dendlo,f  ;remainder in dendhi
	return
        ;
;------------------------ call segmnt
segmnt	addwf	pc,f     ;Convert bcd to 7 seg code
	retlw	0x3f     ;0
	retlw	0x06     ;1
	retlw	0x5b     ;2
	retlw	0x4f	 ;3
	retlw	0x66	 ;4
	retlw	0x6d     ;5
	retlw	0x7d     ;6
	retlw	0x07	 ;7
	retlw	0x7f	 ;8
	retlw	0x6f	 ;9
 
;-----------------------------CALL DEL__20-----
del_20  movlw	0x10
        movwf	count
again 	decfsz	count,f
	goto	again 
 	return
;-----------------------------CALL WAIT----------------
wait    clrf    ncount    ;About 1 millisec delay
delay1  decf    ncount,1  ;between each digit dsply
        btfss   status,2
        goto	delay1
        return
;
 	org	0x100
;
;This call drives the two segment SWR display
;
display movlw	0x24      ;               
        movwf	fsr       ;set fsr to start of data 
        bcf     porta,2   ;                          
	bcf	porta,3
	movlw	0x02      ;
        movwf   count     ;count digits serviced
repeat  movf    indf,0    ;get data
	movwf	portb     ;
	call    wait      ;output lsb at display right    
	movlw	0x04      ;
	addwf	porta,f   ;
  	incf    fsr,1     ;to next digit
	decfsz  count,f   ;skip next if 0
	goto	repeat    ;
        movlw   0x00	  ;exits with all
	movwf   portb     ;digits off
        return
;
	end
;