/* KW5GP Station Monitor

Displays Voltage, Current, Date and Time with threshold warnings

Uses DS3231 Library from Rinkydinkelectronics.com

Uses Adafruit_ST7735 and Adafruit+GFX libraries

Uses Low Side Current Shunt and AD623 Instrumentation Amp

*/
/***************************************************
  This is a library for the Adafruit 1.8" SPI display.

This library works with the Adafruit 1.8" TFT Breakout w/SD card
  ----> http://www.adafruit.com/products/358
The 1.8" TFT shield
  ----> https://www.adafruit.com/product/802
The 1.44" TFT breakout
  ----> https://www.adafruit.com/product/2088
as well as Adafruit raw 1.8" TFT display
  ----> http://www.adafruit.com/products/618

  Check out the links above for our tutorials and wiring diagrams
  These displays use SPI to communicate, 4 or 5 pins are required to
  interface (RST is optional)
  Adafruit invests time and resources providing this open source code,
  please support Adafruit and open-source hardware by purchasing
  products from Adafruit!

  Written by Limor Fried/Ladyada for Adafruit Industries.
  MIT license, all text above must be included in any redistribution
 ****************************************************/

#include <Adafruit_GFX.h>    // Core graphics library
#include <Adafruit_ST7735.h> // Hardware-specific library
#include <SPI.h>

#include <DS3231.h>

// For the breakout, you can use any 2 or 3 pins
// These pins will also work for the 1.8" TFT shield
#define TFT_CS     10
#define TFT_RST    9  // you can also connect this to the Arduino reset
                      // in which case, set this #define pin to 0!
#define TFT_DC     8

// Option 1 (recommended): must use the hardware SPI pins
// (for UNO thats sclk = 13 and sid = 11) and pin 10 must be
// an output. This is much faster - also required if you want
// to use the microSD card (see the image drawing example)
Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS,  TFT_DC, TFT_RST);

#define backlight 3 // Define the pin used for the backlight
#define voltage_pin A1
#define current_pin A0

// Init the DS1307
DS3231 rtc(SDA, SCL);

int current_cal_0 = 0;
int current_cal_max = 199;


float voltage, current;
float volt_drop = 0.75;
int volt_cal = 2490;

float current_high = 25;
float voltage_low = 11.9;
float voltage_high = 14.0;
float temperature;
String rtcdate, rtctime, rtcday, rtcmonth, rtcyear ;

void setup() 
{

  // Use this initializer if you're using a 1.8" TFT
  tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab

  pinMode(backlight, OUTPUT); // Set up the backlight pin as output
  digitalWrite(backlight, HIGH);  // Turn on the backlight

  // Initialize the rtc object
  rtc.begin();

  // The following lines can be uncommented to set the time
  //rtc.setDOW(SUNDAY);        // Set Day-of-Week to SUNDAY
  //rtc.setTime(8,40,0);     // Set the time to 12:45:00 (24hr format)
  //rtc.setDate(3,7,2016);   // Set the date to May 30 2016. Note: format is dd.mm.yyyy      

  tft.fillScreen(ST7735_BLUE); // Clear the display
  tft.setRotation(1); // Set the screen rotation
  tft.setTextWrap(false);
  tft.setTextSize(2);
  tft.setTextColor(ST7735_GREEN);
  tft.setCursor(50,30);  
  tft.print("KW5GP");
  tft.setCursor(37,60);      
  tft.print("Station");
  tft.setCursor(37,80);      
  tft.print("Monitor");  
  delay (5000);
  
  tft.fillScreen(ST7735_BLUE);  
  
}

void loop() 
{

  tft.setTextSize(3);
  tft.setTextColor(ST7735_GREEN);
  tft.fillScreen(ST7735_BLUE); 
  tft.setCursor(40,5);  
  tft.print("KW5GP");

do
{
  
  tft.setTextSize(3);  
  tft.setCursor(30,40);
  
  readCurrent();
  readVoltage();
  tft.setTextColor(ST7735_GREEN,ST7735_BLUE);
  if(current >= current_high)
  {
    tft.setTextColor(ST7735_RED,ST7735_BLUE);
  }
  tft.print(current,1);
  tft.print(" A  ");
  tft.setCursor(30,70);
  tft.setTextColor(ST7735_GREEN,ST7735_BLUE);
  if(voltage <= voltage_low)
  {
    tft.setTextColor(ST7735_YELLOW,ST7735_BLUE);
  }
  else
  {
    if(voltage >= voltage_high)
    {
      tft.setTextColor(ST7735_RED,ST7735_BLUE);
    } 
  }
  
  tft.print(voltage,1);
  tft.print(" V  ");
  tft.setTextColor(ST7735_GREEN,ST7735_BLUE); 
  tft.setTextSize(2);
  tft.setCursor(55,100);
  temperature = rtc.getTemp();
  temperature = (temperature * 1.8) + 32;
  tft.print(temperature,0);
  tft.print(" F ");
  tft.setTextSize(1);   
  tft.setCursor(0,120);
  rtcdate = rtc.getDateStr();
  rtcmonth = rtcdate.substring(3,5);
  rtcday = rtcdate.substring(0,2);
  rtcyear = rtcdate.substring(6,10);
  rtctime = rtc.getTimeStr();
  rtctime = rtctime.substring(0,5);
  tft.setCursor(0,120); 
  tft.print(" "); 
  tft.print(rtc.getDOWStr());
  tft.print(" ");
  tft.print(rtcmonth);
  tft.print("/");
  tft.print(rtcday);
  tft.print("/");
  tft.print(rtcyear);
  tft.print(" ");
  tft.print(rtctime);
 


  delay(10000);

} while (true);
}

void readVoltage()
{
  float count = analogRead(voltage_pin);
  voltage = map(count,0,1023,0,volt_cal);
  
//  voltage = random(0,1500); // For display test
 
  voltage = (voltage/100)+ volt_drop;// Map the Voltage A/D value to voltage
}

void readCurrent()
{
  float count = analogRead(current_pin);  // read the Current value
  count = count + current_cal_0; // set the zero center point at approx 0 V
  current = map(count,current_cal_0,current_cal_max,0,500);  // convert it to Amps XX.X
//current = count;
//  current = random(0,300); // For display test
  
  current = current /10;
}


