/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*  Copyright (C) 1994 Ken Staton  */
/*      All Rights Reserved        */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

/*******************************************************************
**	The WINEXEC functions require                                 **
**  Options:Project:Linker:Catagory(Windows Libraries: TOOLHELP)  **
*******************************************************************/

/*
** 
**	This program is the library manager for binary speech records
**	used in digitized speech implementations.
**
**	It compiles a source file into an assembler formatted text file
**	and a binary data file.
**
**	The source file format is:
**		Label	filename
**		Label	filename
**		  :         :
**		  :         :
**		Label	filename
**
**	Where "Label" is used as the label for the binary data in
**	the assembler text file, and "filename" is the name of the
**	binary data corresponding to label.
**
**	K Staton 6/1/93
**
**	The WINEXEC functions require 
**  Options:Project:Linker:Catagory(Windows Libraries: TOOLHELP)
*/       

/*

TEXT FILE OUPUT...
TEXT file "directory":
LABEL0	DW	start0			;filename
		DW	stop0
LABEL1	DW	start1			;filename
		DW	stop1
		.
		.
		.
LABELn	DW	startn			;filename
		DW	stopn             
		
BINARY FILE OUTPUT...
BIN file data:
0data0						{start0=$+0x1000}
  .
  .
  .
0datay						{stop0=$+y+0x1000}
1data0						{start1=$+y+1+0x1000}
  .
  .
  .
1dataz 
  .
  .

assuming binary data starts at 0x1000.

*/  		

	
#define BASE_ADDR 0x1000; /* default */

#include <windows.h>
#include <stdio.h>    
#include <io.h> 
#include <stdlib.h>
#include <malloc.h>  
#include <math.h> 
#include <string.h>    
#include <toolhelp.h>

                   
/* GLOBALS */                    
FILE *infile_t, *infile_b;
FILE *outfile_t, *outfile_b;
FILE *testfile;     

char SrcFile[255];
char SrcFileTxt[255];
char TgtFileBin[255],TgtFileTxt[255];
char WrkFilePCM[255];  
char label[16],addrl_t[16],addrh_t[16];

                
void main(void)
{  
unsigned char data;
int i;
unsigned int addrl,addrh;
char fname[255],cmdstr[255],filestr[255];
char *dot;
/*MSG msg;  */
HINSTANCE ghInstChild; 
TASKENTRY te;    
int done;
          

_wabout("Creates speech files for assembly.\nCopyright (C) 1994 Ken Staton.\nAll Rights Reserved.\n");    
          
          
printf("Enter the library name (no extension): \n");
scanf("%s",SrcFile); 

strcpy(SrcFileTxt,SrcFile);	/* Source file is text */
strcat(SrcFileTxt,".src"); 

strcpy(TgtFileTxt,SrcFile);	/* Target text file for inclusion in assy source */
strcat(TgtFileTxt,".txt");

strcpy(TgtFileBin,SrcFile);	/* Target binary file for programming EPROM */
strcat(TgtFileBin,".bin");

/* OPEN FILES */
   
/* Open source file for read */

if( (infile_t  = fopen( SrcFileTxt, "rt" )) == NULL )
  {
  printf("The file %s was not opened\n",SrcFileTxt);
  exit(-1);
  }
else
  {
  printf( "The file %s was opened\n",SrcFileTxt );
  }  

/* open text output file */

if( (outfile_t = fopen( TgtFileTxt, "w+t" )) == NULL )
  {
  printf( "The file %s was not opened\n",TgtFileTxt );
  exit(-1);
  }
else
  {
  printf( "The file %s was opened\n",TgtFileTxt );
  }

/* open binary output file */                          

if( (outfile_b = fopen( TgtFileBin, "w+b" )) == NULL )
  {
  printf( "The file %s was not opened\n",TgtFileBin );
  exit(-1);
  }
else
  {
  printf( "The file %s was opened\n",TgtFileBin );
  }

/* base address... */

printf("Enter the base address in HEX: \n");
scanf("%X",&addrl);

/* start processing library... */

/* addrl=BASE_ADDR; */     /* default disabled! */
fscanf(infile_t,"%s %s",label,fname);
while (feof(infile_t) == 0)
  {  
  dot=strchr(fname,'.');		/* find "." in filename */
  fname[dot-fname]='\000';		/* replace with NULL terminator */
  /* form command string... */
  strcpy(cmdstr,"voc2bin.exe ");
  strcat(cmdstr,fname);
  strcat(cmdstr,".VOC ");
  strcat(cmdstr,fname);
  strcat(cmdstr,".BIN");
  
  /* call voc2bin.exe fname.VOC fname.BIN */
  ghInstChild=(HINSTANCE)WinExec(cmdstr, SW_SHOWMINIMIZED);  

  /* test for done */ 
  done=0;
  while (!done)
    {        
    done=1; /* assume done */
    te.dwSize=sizeof(TASKENTRY);
    TaskFirst(&te); 
    if (te.hInst==ghInstChild) done=0;
    while (TaskNext(&te))
      {
      if (te.hInst==ghInstChild) done=0;
      _wyield();
      }
    _wyield();
    }

  
  /* form command string */
  strcpy(cmdstr,"adpcm2.exe ");
  strcat(cmdstr,fname);
  strcat(cmdstr,".BIN ");
  strcat(cmdstr,fname);
  strcat(cmdstr,".PCM");   
  
  /* call adpcm2 fname.BIN fname.PCM */
  ghInstChild=(HINSTANCE)WinExec(cmdstr, SW_SHOWMINIMIZED);  

  /* test for done */ 
  done=0;
  while (!done)
    {        
    done=1; /* assume done */
    te.dwSize=sizeof(TASKENTRY);
    TaskFirst(&te); 
    if (te.hInst==ghInstChild) done=0;
    while (TaskNext(&te))
      {
      if (te.hInst==ghInstChild) done=0;
      _wyield();
      }
    _wyield();
    }

 
  
  /* open ____.pcm file */      
  strcpy(WrkFilePCM,fname);
  strcat(WrkFilePCM,".PCM");
  
  if( (infile_b  = fopen( WrkFilePCM, "rb" )) == NULL )
    {
    printf("The file %s was not opened\n",WrkFilePCM);
    /*exit(-1);*/
    }
  else
    {
    printf( "The file %s was opened\n",WrkFilePCM );
    }  
  
  /* append binary ____.pcm file to speech.bin output */
  i=1;
  data=fgetc(infile_b);   
  while (feof(infile_b) == 0)
    { 
    i++;  
    fputc(data,outfile_b);   
    data=fgetc(infile_b);
    }
  i-=1;
  fputc('\000',outfile_b);		/* write terminator byte */
    							/* 8051 loop ends when DPTR = end
    							** and this is a pre-test, so it
    							** doesn't get output.
    							*/ 
      
  if (infile_b != NULL)
    if( fclose( infile_b ) )
      printf( "The file %s was not closed\n",WrkFilePCM );       

  _itoa(addrl,addrl_t,16);		/* previously set */
  
  addrh=addrl+i;				/* i > 0 includes terminator byte */
  								/* addrh = addrl when i = zero bytes */
  _itoa(addrh,addrh_t,16);
  
  addrl=addrl+i+1;    			/* set to next */
    
  /* write text output with columns aligned */  
  if (strlen(addrl_t)==2)
     fprintf(outfile_t,"%s\t.DW\t000%sH\t;%s\n",label,addrl_t,fname);
  if (strlen(addrl_t)==3)
     fprintf(outfile_t,"%s\t.DW\t00%sH\t;%s\n",label,addrl_t,fname);
  if (strlen(addrl_t)==4)
     fprintf(outfile_t,"%s\t.DW\t0%sH\t;%s\n",label,addrl_t,fname);
     
  if (strlen(addrh_t)==2)
     fprintf(outfile_t,"\t.DW\t000%sH\n",addrh_t); 
  if (strlen(addrh_t)==3)
     fprintf(outfile_t,"\t.DW\t00%sH\n",addrh_t);
  if (strlen(addrh_t)==4)
     fprintf(outfile_t,"\t.DW\t0%sH\n",addrh_t);
  
  /* cleanup...
  ** delete ____.bin file
  ** delete ____.pcm file
  */     
  
  strcpy(filestr,fname);
  strcat(filestr,".BIN");                
  if( remove( filestr ) == -1 )
      printf( "Could not delete %s",filestr );
   else
      printf( "Deleted %s \n",filestr );
                       
  strcpy(filestr,fname);
  strcat(filestr,".PCM");                       
  if( remove( filestr ) == -1 )
      printf( "Could not delete %s",filestr );
   else
      printf( "Deleted %s \n",filestr );  
  
  fscanf(infile_t,"%s %s",label,fname);  /* get next line... */
  } /* while (feof(infile_t) == 0) */                       



/* Close streams */
if( fclose( infile_t ) )
  printf( "The file %s was not closed\n",SrcFileTxt ); 
if( fclose( outfile_t ) )
  printf( "The file %s was not closed\n",TgtFileTxt ); 
if( fclose( outfile_b ) )
  printf( "The file %s was not closed\n",TgtFileBin );  

printf("Done.\n");  

}    /* end main */