/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*  Copyright (C) 1994 Ken Staton  */
/*      All Rights Reserved        */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

/* 
** This program strips the header off a SoundBlaster *.VOC
** file.  It only works with files that were recorded in mono
** using 8 bit uncompressed format.
**
** The file format was empirically determined by using 
** Creative Labs' VOC-HDR.EXE with known binary files.
** 
** There is a 32 byte header prepended to the binary data,
** and a 4 byte terminator (= 0) appended to the data.
*/             


#include <stdio.h> 
#include <stdlib.h>
#include <string.h> 
#include <io.h>
                
FILE *infile, *outfile;
char sf[255],tf[255];
                
void main(argc,argv)
int argc;
char *argv[];
{               
int numclosed; 
unsigned int i;
unsigned char b1,b2,b3,b4,b5;
char response;     

_wabout("Converts *.VOC files to *.BIN.\nCopyright (C) 1994 Ken Staton.\nAll Rights Reserved.\n");   
 

if (argc != 3)
  {
  printf("Enter the source file: \n");
  scanf("%s",sf);
  printf("Enter the target file: \n");
  scanf("%s",tf);
  }
else
  {
  strcpy(sf,argv[1]);
  strcpy(tf,argv[2]); 
  _wsetexit(_WINEXITNOPERSIST);	/* assume no persistence */
  }  

   
/* Open for read (will fail if source file does not exist) */
if( (infile  = fopen( sf, "rb" )) == NULL )
  printf( "The file %s was not opened\n",sf );
else
  printf( "The file %s was opened\n",sf );

/* Open for write */
/* test for overwrite! */
if( (outfile = fopen( tf, "rb")) != NULL)
  {
  printf("%s Exists!  OVERWRITE (y/n)?",tf);
  scanf("%s",&response);
  if ((response!='Y') && (response!='y')) exit(-1);
  if( fclose( outfile ) ) printf( "The file %s was not closed\n",tf );  
  printf("\n\n");
  }  
  
if( (outfile = fopen( tf, "w+b" )) == NULL )
  printf( "The file %s was not opened\n",tf );
else
  printf( "The file %s was opened\n",tf );

/* 
** Now process .VOC file 
*/
   
b1=getc(infile);	/* look ahead to keep from outputting	*/
b2=getc(infile);	/* any of the null terminators 			*/
b3=getc(infile);	/* appended to the *.VOC file			*/
b4=getc(infile);
b5=getc(infile);   
i=0; /* count from b1, since this is what is output */
while ( (feof(infile) == 0) ) 
  {  
  if (i>=32)	/* don't output the 1st 32 bytes (header) */
    {  
    putc(b1,outfile); 
    }
  b1=b2;			/* terminating null #1 */
  b2=b3;			/* terminating null #2 */
  b3=b4;			/* terminating null #3 */
  b4=b5;			/* terminating null #4 */
  b5=getc(infile);	/* read past end of file sets EOF) */
  i++;
  } 

   
/* Close stream */
if( fclose( infile ) )
  printf( "The file %s was not closed\n",sf );
/* All other files are closed: */
numclosed = _fcloseall( );
printf( "Number of files closed: %u\n", numclosed );

}
